/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.scope.value;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.scope.value.IndexValue;
import de.firemage.autograder.core.integrated.scope.value.Value;
import java.util.Objects;
import java.util.Optional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;

public final class VariableValue
implements Value,
IndexValue {
    private final CtExpression<?> value;

    private VariableValue(CtExpression<?> value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> IndexValue fromExpression(CtExpression<T> expression) {
        return new VariableValue(Objects.requireNonNull(expression));
    }

    public static <T> IndexValue fromLiteral(CtLiteral<T> literal) {
        return VariableValue.fromExpression(literal);
    }

    public static IndexValue fromInteger(int value) {
        return new VariableValue((CtExpression<?>)SpoonUtil.makeLiteral(value));
    }

    @Override
    public Optional<CtExpression<?>> toExpression() {
        return Optional.of(this.value);
    }

    @Override
    public boolean isEqual(IndexValue other) {
        return this.equals(other);
    }

    @Override
    public int hashValue() {
        return this.hashCode();
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Value)) {
            return false;
        }
        Value that = (Value)otherObject;
        CtExpression left = this.toExpression().orElse(null);
        CtExpression right = that.toExpression().orElse(null);
        if (left instanceof CtLiteral) {
            CtLiteral leftLit = (CtLiteral)left;
            if (right instanceof CtLiteral) {
                CtLiteral rightLit = (CtLiteral)right;
                return SpoonUtil.areLiteralsEqual(leftLit, rightLit);
            }
        }
        return this.toExpression().equals(that.toExpression());
    }

    public int hashCode() {
        return this.toExpression().hashCode();
    }

    public String toString() {
        return this.toExpression().map(Object::toString).orElse("null");
    }
}

