/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.scope.value;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.scope.Scope;
import de.firemage.autograder.core.integrated.scope.value.IndexValue;
import de.firemage.autograder.core.integrated.scope.value.IndexValueWrapper;
import de.firemage.autograder.core.integrated.scope.value.UnknownValue;
import de.firemage.autograder.core.integrated.scope.value.Value;
import de.firemage.autograder.core.integrated.scope.value.VariableValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;

public final class ArrayValue
implements Value {
    private Value defaultValue;
    private final Map<IndexValueWrapper, Value> values;

    private ArrayValue(Value defaultValue, Map<IndexValueWrapper, Value> values) {
        this.defaultValue = defaultValue;
        this.values = values;
    }

    public static ArrayValue unknown() {
        return new ArrayValue(new UnknownValue(), new HashMap<IndexValueWrapper, Value>());
    }

    public static <T> ArrayValue fromNew(CtNewArray<T> ctNewArray) {
        CtTypeReference ctTypeReference = ctNewArray.getType();
        if (!(ctTypeReference instanceof CtArrayTypeReference)) {
            throw new IllegalArgumentException("Unknown array type: " + String.valueOf(ctNewArray.getType()));
        }
        CtArrayTypeReference arrayType = (CtArrayTypeReference)ctTypeReference;
        CtLiteral defaultValue = SpoonUtil.getDefaultValue(arrayType.getArrayType());
        HashMap<IndexValueWrapper, Value> values = new HashMap<IndexValueWrapper, Value>();
        int i = 0;
        for (CtExpression expression : ctNewArray.getElements()) {
            values.put(new IndexValueWrapper(VariableValue.fromInteger(i)), VariableValue.fromExpression(expression));
            ++i;
        }
        return new ArrayValue(VariableValue.fromLiteral(defaultValue), values);
    }

    public void set(IndexValue index, Value value) {
        this.values.put(new IndexValueWrapper(index), value);
    }

    private Value defaultValue() {
        return this.defaultValue;
    }

    public void invalidate() {
        this.defaultValue = new UnknownValue();
        this.values.clear();
    }

    public Value get(IndexValue index, Scope scope) {
        Value potentialValue = this.values.get(new IndexValueWrapper(index));
        if (potentialValue != null) {
            return potentialValue;
        }
        return index.toExpression().map(scope::resolve).flatMap(resolved -> Optional.ofNullable(this.values.get(new IndexValueWrapper((IndexValue)resolved)))).orElseGet(this::defaultValue);
    }

    @Override
    public Optional<CtExpression<?>> toExpression() {
        if (this.values.isEmpty()) {
            return this.defaultValue().toExpression();
        }
        Value result = this.defaultValue();
        for (Value value : this.values.values()) {
            if (value.equals(result)) continue;
            return Optional.empty();
        }
        return result.toExpression();
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof ArrayValue)) {
            return false;
        }
        ArrayValue that = (ArrayValue)otherObject;
        return this.defaultValue().equals(that.defaultValue()) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.values);
    }
}

