/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.scope;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.scope.Scope;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtRHSReceiver;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;

public class ScopedVisitor
extends CtScanner {
    private final Scope scope = new Scope();

    protected ScopedVisitor() {
    }

    protected Scope getScope() {
        return this.scope;
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        CtExpression ctExpression = assignment.getAssigned();
        if (ctExpression instanceof CtVariableWrite) {
            CtVariableWrite variable = (CtVariableWrite)ctExpression;
            this.updateValueAssignment(variable.getVariable(), assignment.getAssignment());
        } else {
            ctExpression = assignment.getAssigned();
            if (ctExpression instanceof CtArrayWrite) {
                CtArrayWrite arrayWrite = (CtArrayWrite)ctExpression;
                this.scope.registerOrUpdateArray(arrayWrite, assignment.getAssignment());
            }
        }
        super.visitCtAssignment(assignment);
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        this.scope.push();
        super.visitCtBlock(block);
        this.scope.pop();
    }

    public <R> void visitCtField(CtField<R> field) {
        this.scope.register((CtVariableReference<?>)field.getReference(), (CtExpression<?>)field.getDefaultExpression());
        this.updateValueAssignment((CtVariableReference)field.getReference(), (CtExpression<?>)field.getAssignment());
        super.visitCtField(field);
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.scope.register((CtVariableReference<?>)localVariable.getReference(), (CtExpression<?>)SpoonUtil.getDefaultValue(localVariable.getType()));
        this.updateValueAssignment((CtVariableReference<T>)localVariable.getReference(), (CtExpression<?>)localVariable.getAssignment());
        super.visitCtLocalVariable(localVariable);
    }

    public void visitCtFor(CtFor ctFor) {
        this.enter((CtElement)ctFor);
        this.scan(CtRole.ANNOTATION, ctFor.getAnnotations());
        this.scan(CtRole.FOR_INIT, ctFor.getForInit());
        for (CtStatement statement : ctFor.getForInit()) {
            if (!(statement instanceof CtLocalVariable)) continue;
            CtLocalVariable variable = (CtLocalVariable)statement;
            this.scope.remove((CtVariableReference<?>)variable.getReference());
        }
        this.scan(CtRole.EXPRESSION, (CtElement)ctFor.getExpression());
        this.scan(CtRole.FOR_UPDATE, ctFor.getForUpdate());
        this.scan(CtRole.BODY, (CtElement)ctFor.getBody());
        this.scan(CtRole.COMMENT, ctFor.getComments());
        this.exit((CtElement)ctFor);
    }

    public <R> void visitCtVariableWrite(CtVariableWrite<R> variableWrite) {
        if (variableWrite instanceof CtRHSReceiver) {
            CtRHSReceiver rhs = (CtRHSReceiver)variableWrite;
            this.updateValueAssignment(variableWrite.getVariable(), rhs.getAssignment());
        }
        super.visitCtVariableWrite(variableWrite);
    }

    private <T> void updateValueAssignment(CtVariableReference<T> variable, CtExpression<?> value) {
        if (value != null) {
            this.scope.updateOrRegister(variable, value);
        }
    }
}

