/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.scope;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.scope.value.ArrayValue;
import de.firemage.autograder.core.integrated.scope.value.IndexValue;
import de.firemage.autograder.core.integrated.scope.value.UnknownValue;
import de.firemage.autograder.core.integrated.scope.value.Value;
import de.firemage.autograder.core.integrated.scope.value.VariableValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.reference.CtVariableReference;

public final class Scope {
    private final List<Map<CtVariableReference<?>, Value>> variables = new ArrayList();

    Scope() {
        this.variables.add(new HashMap());
    }

    private Value resolveArrayRead(CtArrayRead<?> ctArrayRead) {
        IndexValue index = (IndexValue)this.resolve(ctArrayRead.getIndexExpression());
        CtVariableReference variable = SpoonUtil.getVariableFromArray(ctArrayRead).getVariable();
        Value storedValue = this.get(variable);
        if (storedValue == null) {
            return new UnknownValue();
        }
        if (!(storedValue instanceof ArrayValue)) {
            throw new IllegalArgumentException("Variable " + String.valueOf(variable) + " is not stored as an array, but should be");
        }
        ArrayValue arrayValue = (ArrayValue)storedValue;
        return arrayValue.get(index, this);
    }

    public Optional<CtLiteral<?>> tryResolveLiteral(CtExpression<?> expression) {
        if (expression instanceof CtLiteral) {
            CtLiteral literal = (CtLiteral)expression;
            return Optional.of(literal);
        }
        return this.resolve(expression).toLiteral();
    }

    public Optional<CtLiteral<?>> tryResolveLiteral(Value value) {
        return value.toExpression().map(this::resolve).flatMap(Value::toLiteral);
    }

    public Value resolve(CtExpression<?> value) {
        if (value instanceof CtVariableRead) {
            CtVariableRead access = (CtVariableRead)value;
            Value varValue = this.get(access.getVariable());
            if (varValue != null) {
                return varValue.toExpression().map(this::resolve).orElse(varValue);
            }
        } else {
            if (value instanceof CtLiteral) {
                CtLiteral literal = (CtLiteral)value;
                return VariableValue.fromLiteral(literal);
            }
            if (value instanceof CtNewArray) {
                CtNewArray newArray = (CtNewArray)value;
                return ArrayValue.fromNew(newArray);
            }
            if (value instanceof CtArrayRead) {
                CtArrayRead ctArrayRead = (CtArrayRead)value;
                return this.resolveArrayRead(ctArrayRead);
            }
        }
        return VariableValue.fromExpression(value);
    }

    void register(CtVariableReference<?> variable, CtExpression<?> value) {
        this.register(variable, this.resolve(value));
    }

    private void register(CtVariableReference<?> variable, Value value) {
        this.variables.get(this.variables.size() - 1).put(variable, value);
    }

    void update(CtVariableReference<?> variable, CtExpression<?> value) {
        for (int i = this.variables.size() - 1; i >= 0; --i) {
            if (!this.variables.get(i).containsKey(variable)) continue;
            this.variables.get(i).put(variable, this.resolve(value));
            return;
        }
        throw new IllegalArgumentException("Variable " + String.valueOf(variable) + " is not registered in any scope");
    }

    void registerOrUpdateArray(CtArrayWrite<?> ctArrayWrite, CtExpression<?> value) {
        Value resolvedValue = this.resolve(value);
        CtVariableReference variableReference = SpoonUtil.getVariableFromArray(ctArrayWrite).getVariable();
        Value storedValue = this.get(variableReference);
        IndexValue index = VariableValue.fromExpression(ctArrayWrite.getIndexExpression());
        if (storedValue != null) {
            ArrayValue arrayValue = (ArrayValue)storedValue;
            if (!index.isConstant()) {
                Value resolvedIndex = index.toExpression().map(this::resolve).orElse(index);
                if (!resolvedIndex.isConstant() || !(resolvedIndex instanceof IndexValue)) {
                    arrayValue.invalidate();
                }
                index = (IndexValue)resolvedIndex;
            }
            arrayValue.set(index, resolvedValue);
        } else {
            ArrayValue newValue = ArrayValue.unknown();
            newValue.set(index, resolvedValue);
            this.register(variableReference, newValue);
        }
    }

    void updateOrRegister(CtVariableReference<?> variable, CtExpression<?> value) {
        try {
            this.update(variable, value);
        }
        catch (IllegalArgumentException e) {
            this.register(variable, value);
        }
    }

    public Value get(CtVariableReference<?> variable) {
        ArrayList reversedVars = new ArrayList(this.variables);
        Collections.reverse(reversedVars);
        for (Map map : reversedVars) {
            if (!map.containsKey(variable)) continue;
            return (Value)map.get(variable);
        }
        return null;
    }

    public void remove(CtVariableReference<?> ctVariableReference) {
        ArrayList reversedVars = new ArrayList(this.variables);
        Collections.reverse(reversedVars);
        for (Map<CtVariableReference<?>, Value> scope : reversedVars) {
            Value v = scope.remove(ctVariableReference);
            if (v == null) continue;
            return;
        }
    }

    void push() {
        this.variables.add(new HashMap());
    }

    void pop() {
        this.variables.remove(this.variables.size() - 1);
        if (this.variables.isEmpty()) {
            this.variables.add(new HashMap());
        }
    }
}

