/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.reflect.code.CtLiteralImpl;

public final class SpoonUtil {
    private SpoonUtil() {
    }

    public static boolean isString(CtTypeReference<?> type) {
        return type.getQualifiedName().equals("java.lang.String");
    }

    public static Optional<CtTypeReference<?>> isToStringCall(CtExpression<?> expression) {
        CtInvocation invocation;
        if (!SpoonUtil.isString(expression.getType())) {
            return Optional.empty();
        }
        if (expression instanceof CtInvocation && (invocation = (CtInvocation)expression).getExecutable().getSignature().equals("toString()")) {
            return Optional.of(invocation.getTarget().getType());
        }
        return Optional.empty();
    }

    public static boolean isNullLiteral(CtExpression<?> expression) {
        CtLiteral literal;
        return expression instanceof CtLiteral && (literal = (CtLiteral)expression).getValue() == null;
    }

    public static boolean isIntegerLiteral(CtExpression<?> expression, int value) {
        CtLiteral literal;
        return expression instanceof CtLiteral && (literal = (CtLiteral)expression).getValue().equals(value);
    }

    public static boolean isStringLiteral(CtExpression<?> expression, String value) {
        CtLiteral literal;
        return expression instanceof CtLiteral && (literal = (CtLiteral)expression).getValue() != null && literal.getValue().equals(value);
    }

    public static Optional<Boolean> tryGetBooleanLiteral(CtExpression<?> expression) {
        CtLiteral literal;
        if (expression instanceof CtLiteral && (literal = (CtLiteral)expression).getValue() != null && (literal.getType().getQualifiedName().equals("boolean") || literal.getType().getQualifiedName().equals("java.lang.Boolean"))) {
            return Optional.of((Boolean)literal.getValue());
        }
        return Optional.empty();
    }

    public static boolean areLiteralsEqual(CtLiteral<?> left, CtLiteral<?> right) {
        Number valLeft;
        Object object;
        block15: {
            block14: {
                if (left == null && right == null) {
                    return true;
                }
                if (left == null || right == null) {
                    return false;
                }
                if (left.getValue() == null) {
                    return right.getValue() == null;
                }
                if (right.getValue() == null) {
                    return false;
                }
                Object object2 = left.getValue();
                if (object2 instanceof Character) {
                    Character l = (Character)object2;
                    object2 = right.getValue();
                    if (object2 instanceof Character) {
                        Character r = (Character)object2;
                        return l.equals(r);
                    }
                }
                if ((object2 = left.getValue()) instanceof Number) {
                    Number l = (Number)object2;
                    object2 = right.getValue();
                    if (object2 instanceof Character) {
                        Character r = (Character)object2;
                        return l.intValue() == r.charValue();
                    }
                }
                if ((object2 = left.getValue()) instanceof Character) {
                    Character l = (Character)object2;
                    object2 = right.getValue();
                    if (object2 instanceof Number) {
                        Number r = (Number)object2;
                        return l.charValue() == r.intValue();
                    }
                }
                if (!((object = left.getValue()) instanceof Number)) break block14;
                valLeft = (Number)object;
                object = right.getValue();
                if (object instanceof Number) break block15;
            }
            return left.getValue() == right.getValue() || left.getValue().equals(right.getValue());
        }
        Number valRight = (Number)object;
        if (valLeft instanceof Float || valLeft instanceof Double || valRight instanceof Float || valRight instanceof Double) {
            return valLeft.doubleValue() == valRight.doubleValue();
        }
        return valLeft.longValue() == valRight.longValue();
    }

    public static <T> CtLiteral<T> makeLiteral(T value) {
        CtLiteralImpl literal = new CtLiteralImpl();
        literal.setValue(value);
        return literal;
    }

    public static <T> CtLiteral<T> getDefaultValue(CtTypeReference<T> ty) {
        if (ty.isPrimitive()) {
            return (CtLiteral)Map.ofEntries(Map.entry("int", SpoonUtil.makeLiteral(0)), Map.entry("double", SpoonUtil.makeLiteral(0.0)), Map.entry("float", SpoonUtil.makeLiteral(Float.valueOf(0.0f))), Map.entry("long", SpoonUtil.makeLiteral(0L)), Map.entry("short", SpoonUtil.makeLiteral((short)0)), Map.entry("byte", SpoonUtil.makeLiteral((byte)0)), Map.entry("char", SpoonUtil.makeLiteral(Character.valueOf('\u0000'))), Map.entry("boolean", SpoonUtil.makeLiteral(false))).get(ty.getSimpleName());
        }
        return SpoonUtil.makeLiteral(null);
    }

    public static CtVariableAccess<?> getVariableFromArray(CtArrayAccess<?, ?> ctArrayAccess) {
        CtExpression array = ctArrayAccess.getTarget();
        if (array instanceof CtVariableAccess) {
            return (CtVariableAccess)array;
        }
        if (array instanceof CtArrayAccess) {
            CtArrayAccess access = (CtArrayAccess)array;
            return SpoonUtil.getVariableFromArray(access);
        }
        throw new IllegalArgumentException("Unable to obtain variable from array access: " + String.valueOf(ctArrayAccess));
    }

    public static List<CtStatement> getEffectiveStatements(CtBlock<?> block) {
        return block.getStatements().stream().filter(statement -> !(statement instanceof CtComment)).toList();
    }

    public static CtStatement unwrapStatement(CtStatement statement) {
        CtBlock block;
        List<CtStatement> statements;
        if (statement instanceof CtBlock && (statements = SpoonUtil.getEffectiveStatements(block = (CtBlock)statement)).size() == 1) {
            return statements.get(0);
        }
        return statement;
    }

    public static boolean isGetter(CtMethod<?> method) {
        return method.getSimpleName().startsWith("get") && method.getParameters().isEmpty() && !method.getType().getSimpleName().equals("void") && (method.isAbstract() || SpoonUtil.getEffectiveStatements(method.getBody()).size() == 1);
    }

    public static boolean isSetter(CtMethod<?> method) {
        return method.getSimpleName().startsWith("set") && method.getParameters().size() == 1 && method.getType().getSimpleName().equals("void") && (method.isAbstract() || SpoonUtil.getEffectiveStatements(method.getBody()).size() == 1);
    }

    public static boolean isPrimitiveNumeric(CtTypeReference<?> type) {
        return type.isPrimitive() && !type.getQualifiedName().equals("boolean") && !type.getQualifiedName().equals("char");
    }

    public static boolean isVoidMethod(CtMethod<?> method) {
        return method.getType().getQualifiedName().equals("void");
    }

    public static boolean isEqualsMethod(CtMethod<?> method) {
        return method.getSimpleName().equals("equals") && method.isPublic() && method.getType().getQualifiedName().equals("boolean") && method.getParameters().size() == 1 && ((CtParameter)method.getParameters().get(0)).getType().getQualifiedName().equals("java.lang.Object");
    }

    public static boolean isCompareToMethod(CtMethod<?> method) {
        return method.getSimpleName().equals("compareTo") && method.isPublic() && method.getType().getQualifiedName().equals("boolean") && method.getParameters().size() == 1 && ((CtParameter)method.getParameters().get(0)).getType().getQualifiedName().equals(method.getDeclaringType().getQualifiedName());
    }

    public static Optional<CtJavaDoc> getJavadoc(CtElement element) {
        if (element.getComments().isEmpty() || !(element.getComments().get(0) instanceof CtJavaDoc)) {
            return Optional.empty();
        }
        return Optional.of(((CtComment)element.getComments().get(0)).asJavaDoc());
    }

    public static boolean isStaticCallTo(CtInvocation<?> invocation, String typeName, String methodName) {
        CtTypeAccess access;
        CtExpression ctExpression;
        return invocation.getExecutable().isStatic() && (ctExpression = invocation.getTarget()) instanceof CtTypeAccess && (access = (CtTypeAccess)ctExpression).getAccessedType().getQualifiedName().equals(typeName) && invocation.getExecutable().getSimpleName().equals(methodName);
    }

    public static boolean isEffectivelyFinal(StaticAnalysis staticAnalysis, CtField<?> field) {
        return staticAnalysis.getModel().filterChildren(e -> {
            CtFieldWrite write;
            return e instanceof CtFieldWrite && (write = (CtFieldWrite)e).getVariable().equals((Object)field.getReference());
        }).first() == null;
    }
}

