/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.LinterStatus;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.dynamic.DockerConsoleRunner;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.dynamic.RunnerException;
import de.firemage.autograder.core.dynamic.TestRunResult;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.ModelBuildException;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.graph.GraphAnalysis;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegratedAnalysis
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(IntegratedAnalysis.class);
    private final UploadedFile file;
    private final Path jar;
    private final Path tmpPath;
    private final Map<String, FileSystem> openFileSystems = new HashMap<String, FileSystem>();
    private final StaticAnalysis staticAnalysis;
    private final GraphAnalysis graphAnalysis;
    private DynamicAnalysis dynamicAnalysis;

    public IntegratedAnalysis(UploadedFile file, Path jar, Path tmpPath, Consumer<LinterStatus> statusConsumer) throws ModelBuildException, IOException {
        this.file = file;
        this.jar = jar;
        this.tmpPath = tmpPath;
        this.staticAnalysis = new StaticAnalysis(file, jar, statusConsumer);
        this.graphAnalysis = new GraphAnalysis(this.staticAnalysis);
        this.dynamicAnalysis = new DynamicAnalysis(List.of());
    }

    public void runDynamicAnalysis(Path tests, Consumer<LinterStatus> statusConsumer) throws RunnerException, InterruptedException {
        try {
            DockerConsoleRunner runner = new DockerConsoleRunner(this.toPath(this.getClass().getResource("/executor.jar")), this.toPath(this.getClass().getResource("/agent.jar")), tests, this.tmpPath);
            List<TestRunResult> results = runner.runTests(this.staticAnalysis, this.jar, statusConsumer);
            this.dynamicAnalysis = new DynamicAnalysis(results);
        }
        catch (IOException | URISyntaxException e) {
            throw new RunnerException(e);
        }
        finally {
            this.closeOpenFileSystems();
        }
    }

    private Path toPath(URL resource) throws URISyntaxException, IOException {
        if (resource == null) {
            throw new IllegalArgumentException("URL is null");
        }
        URI uri = resource.toURI();
        if (!uri.toString().contains("!")) {
            return Path.of(uri);
        }
        String[] path = uri.toString().split("!", 2);
        FileSystem fs = this.createFileSystem(path[0]);
        return fs.getPath(path[1], new String[0]);
    }

    private FileSystem createFileSystem(String path) throws IOException {
        FileSystem existingFileSystem = this.openFileSystems.get(path);
        if (existingFileSystem != null) {
            return existingFileSystem;
        }
        FileSystem newFileSystem = FileSystems.newFileSystem(URI.create(path), new HashMap());
        this.openFileSystems.put(path, newFileSystem);
        return newFileSystem;
    }

    private void closeOpenFileSystems() {
        for (FileSystem openFileSystem : this.openFileSystems.values()) {
            try {
                openFileSystem.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.openFileSystems.clear();
    }

    public List<Problem> lint(List<IntegratedCheck> checks, Consumer<LinterStatus> statusConsumer) {
        statusConsumer.accept(LinterStatus.RUNNING_INTEGRATED_CHECKS);
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (IntegratedCheck check : checks) {
            problems.addAll(check.run(this.staticAnalysis, this.dynamicAnalysis, this.file.getFile()));
        }
        return problems;
    }

    public StaticAnalysis getStaticAnalysis() {
        return this.staticAnalysis;
    }

    public DynamicAnalysis getDynamicAnalysis() {
        return this.dynamicAnalysis;
    }

    @Override
    public void close() throws IOException {
        this.staticAnalysis.close();
    }
}

