/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.file;

import de.firemage.autograder.core.compiler.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import org.apache.commons.io.FileUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.support.compiler.FileSystemFolder;

public class UploadedFile {
    private static final Logger log = LoggerFactory.getLogger(UploadedFile.class);
    private final Path file;
    private final JavaVersion version;
    private final Charset charset;

    public UploadedFile(Path file, JavaVersion version) throws IOException {
        if (!file.toFile().isDirectory()) {
            throw new IllegalArgumentException("The file must be a directory");
        }
        this.file = file;
        this.version = version;
        Charset detectedCharset = null;
        for (File javaFile : this.getJavaFiles()) {
            Charset fileCharset;
            String fileCharsetName = UniversalDetector.detectCharset((File)javaFile);
            if (fileCharsetName == null || (fileCharset = Charset.forName(fileCharsetName)).equals(StandardCharsets.US_ASCII)) continue;
            if (detectedCharset != null && !fileCharset.equals(detectedCharset)) {
                throw new IOException("Java files with incompatible encodings found - some are " + String.valueOf(detectedCharset) + ", but others are " + String.valueOf(fileCharset));
            }
            detectedCharset = fileCharset;
        }
        this.charset = Objects.requireNonNullElse(detectedCharset, StandardCharsets.UTF_8);
    }

    public Path getFile() {
        return this.file.toAbsolutePath();
    }

    public List<File> getJavaFiles() throws IOException {
        return this.streamFiles().toList();
    }

    public Stream<File> streamFiles() throws IOException {
        return Files.walk(this.file, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".java")).filter(p -> !p.toString().endsWith("package-info.java")).map(Path::toFile);
    }

    public FileSystemFolder getSpoonFile() {
        return new FileSystemFolder(this.file.toFile());
    }

    public List<FileDataSource> getPMDFiles() throws IOException {
        return Files.walk(this.file, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".java")).map(p -> new FileDataSource(p.toFile())).toList();
    }

    public String getName() {
        return this.file.getFileName().toString();
    }

    public void delete() throws IOException {
        FileUtils.deleteDirectory((File)this.file.toFile());
    }

    public JavaVersion getVersion() {
        return this.version;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

