/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.dynamic;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import de.firemage.autograder.core.LinterStatus;
import de.firemage.autograder.core.dynamic.DockerRunnerException;
import de.firemage.autograder.core.dynamic.RunnerException;
import de.firemage.autograder.core.dynamic.TestRunResult;
import de.firemage.autograder.core.dynamic.TestRunner;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.event.Event;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import spoon.reflect.declaration.CtClass;

public class DockerConsoleRunner
implements TestRunner {
    private static final int TIMEOUT_SECONDS = 60;
    private final Path executor;
    private final Path agent;
    private final Path tests;
    private final Path tmpPath;

    public DockerConsoleRunner(Path executor, Path agent, Path tests, Path tmpPath) {
        this.executor = executor;
        this.agent = agent;
        if (!Files.isDirectory(tests, new LinkOption[0])) {
            throw new IllegalArgumentException("tests must point to a folder containing the individual test cases");
        }
        this.tests = tests;
        this.tmpPath = tmpPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestRunResult> runTests(StaticAnalysis analysis, Path jar, Consumer<LinterStatus> statusConsumer) throws RunnerException, InterruptedException {
        List<Path> testCases;
        String imageId;
        String mainClass = ((CtClass)analysis.findMain().getParent(CtClass.class)).getQualifiedName().replace(".", "/");
        statusConsumer.accept(LinterStatus.BUILDING_DOCKER_IMAGE);
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        ApacheDockerHttpClient client = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        DockerClient dockerClient = DockerClientBuilder.getInstance((DockerClientConfig)config).withDockerHttpClient((DockerHttpClient)client).build();
        try {
            Path buildDirectory = Files.createTempDirectory(this.tmpPath, "docker_build", new FileAttribute[0]);
            Files.copy(Path.of(this.getClass().getResource("Dockerfile").toURI()), buildDirectory.resolve("Dockerfile"), new CopyOption[0]);
            Files.copy(this.executor, buildDirectory.resolve("executor.jar"), new CopyOption[0]);
            Files.copy(this.agent, buildDirectory.resolve("agent.jar"), new CopyOption[0]);
            Files.copy(jar, buildDirectory.resolve("src.jar"), new CopyOption[0]);
            imageId = ((BuildImageResultCallback)dockerClient.buildImageCmd().withBaseDirectory(buildDirectory.toFile()).withDockerfile(buildDirectory.resolve("Dockerfile").toFile()).withPull(Boolean.valueOf(true)).withBuildArg("jarfile", "src.jar").withBuildArg("executor", "executor.jar").withBuildArg("agent", "agent.jar").exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
            try (Stream<Path> walk = Files.walk(buildDirectory, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            try (Stream<Path> files = Files.walk(this.tests, new FileVisitOption[0]);){
                testCases = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.toString().endsWith(".txt") || f.toString().endsWith(".protocol")).toList();
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RunnerException(e);
        }
        statusConsumer.accept(LinterStatus.EXECUTING_TESTS);
        try {
            ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            ArrayList<Future<TestRunResult>> futures = new ArrayList<Future<TestRunResult>>();
            for (Path testPath : testCases) {
                futures.add(service.submit(() -> this.executeTestCase(dockerClient, imageId, testPath, mainClass)));
            }
            ArrayList<TestRunResult> results = new ArrayList<TestRunResult>();
            for (Future future : futures) {
                try {
                    results.add((TestRunResult)future.get());
                }
                catch (ExecutionException e) {
                    throw new RunnerException(e.getCause());
                }
            }
            service.shutdown();
            System.out.println(System.lineSeparator());
            System.out.println(results.stream().filter(t -> t.status() == TestRunResult.TestRunStatus.OK).count() + "/" + results.size() + " tests successful");
            ArrayList<TestRunResult> arrayList = results;
            return arrayList;
        }
        finally {
            dockerClient.removeImageCmd(imageId).withForce(Boolean.valueOf(true)).exec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestRunResult executeTestCase(DockerClient dockerClient, String imageId, Path testFile, String mainClass) throws IOException, InterruptedException, DockerRunnerException {
        List<String> interactionLines = Files.readAllLines(testFile);
        String containerId = dockerClient.createContainerCmd(imageId).withHostConfig(new HostConfig().withCapDrop(new Capability[0]).withNetworkMode("none").withPidsLimit(Long.valueOf(2000L)).withMemory(Long.valueOf(0xC800000L))).withCmd(new String[]{mainClass, Base64.getEncoder().encodeToString(String.join((CharSequence)"\n", interactionLines).getBytes(StandardCharsets.UTF_8)), String.valueOf(false)}).exec().getId();
        try {
            List events;
            int exitCode;
            dockerClient.startContainerCmd(containerId).exec();
            TestRunResult.TestRunStatus status = TestRunResult.TestRunStatus.OK;
            try {
                exitCode = ((WaitContainerResultCallback)dockerClient.waitContainerCmd(containerId).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode(60L, TimeUnit.SECONDS);
            }
            catch (DockerClientException ex) {
                throw new DockerRunnerException("The test container timed out", this.readLogs(dockerClient, containerId));
            }
            if (exitCode == 1) {
                status = TestRunResult.TestRunStatus.ERROR_TEST_FAILURE;
            } else if (exitCode == 2) {
                throw new DockerRunnerException("The executor failed", this.readLogs(dockerClient, containerId));
            }
            String logs = this.readLogs(dockerClient, containerId);
            try {
                InputStream tar = dockerClient.copyArchiveFromContainerCmd(containerId, "/home/student/codelinter_events.txt").exec();
                events = Event.read((InputStream)this.extractSingleFileFromTar(tar));
            }
            catch (NotFoundException ex) {
                events = List.of();
            }
            Object object = this;
            synchronized (object) {
                System.out.println(System.lineSeparator());
                System.out.println(logs);
                if (events.isEmpty()) {
                    System.err.println("No events found. Maybe the student's code timed out.");
                    System.err.flush();
                }
            }
            object = new TestRunResult(events, status, logs);
            return object;
        }
        finally {
            dockerClient.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).exec();
        }
    }

    private InputStream extractSingleFileFromTar(InputStream tar) throws IOException {
        TarArchiveInputStream tarStream = new TarArchiveInputStream(tar);
        if (tarStream.getNextEntry() == null) {
            throw new IllegalArgumentException("No file found inside the tar file");
        }
        return tarStream;
    }

    private String readLogs(DockerClient client, String containerId) throws InterruptedException {
        final StringBuilder log = new StringBuilder();
        ((ResultCallback.Adapter)client.logContainerCmd(containerId).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){

            public void onNext(Frame frame) {
                log.append(frame);
                log.append(System.lineSeparator());
            }
        })).awaitCompletion();
        return log.toString();
    }
}

