/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.compiler;

import de.firemage.autograder.core.compiler.CompilationDiagnostic;
import de.firemage.autograder.core.compiler.CompilationFailureException;
import de.firemage.autograder.core.compiler.CompilationResult;
import de.firemage.autograder.core.compiler.JavaVersion;
import de.firemage.autograder.core.compiler.PhysicalFileObject;
import de.firemage.autograder.core.compiler.SeparateBinaryFileManager;
import de.firemage.autograder.core.file.UploadedFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;

public final class Compiler {
    public static final Locale COMPILER_LOCALE = Locale.US;

    private Compiler() {
    }

    public static Optional<CompilationResult> compileToJar(UploadedFile input, Path tmpLocation, JavaVersion javaVersion) throws IOException, CompilationFailureException {
        return Compiler.compileWithEncoding(input, tmpLocation, javaVersion, input.getCharset());
    }

    public static Optional<CompilationResult> compileWithEncoding(UploadedFile input, Path tmpLocation, JavaVersion javaVersion, Charset charset) throws IOException, CompilationFailureException {
        List<PhysicalFileObject> compilationUnits = input.streamFiles().map(file -> new PhysicalFileObject((File)file, charset)).toList();
        if (compilationUnits.isEmpty()) {
            return Optional.empty();
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Path compilerOutput = tmpLocation.resolve(input.getName() + "_compiled");
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StringWriter output = new StringWriter();
        SeparateBinaryFileManager fileManager = new SeparateBinaryFileManager(compiler.getStandardFileManager(diagnosticCollector, Locale.US, charset), compilerOutput.toFile(), charset);
        boolean successful = compiler.getTask(output, fileManager, diagnosticCollector, Arrays.asList("-Xlint:all", "-Xlint:-processing", "-Xlint:-serial", "--release=" + javaVersion.getVersionString()), null, compilationUnits).call();
        output.flush();
        output.close();
        if (!successful) {
            throw new CompilationFailureException(diagnosticCollector.getDiagnostics().stream().map(d -> new CompilationDiagnostic((Diagnostic<? extends JavaFileObject>)d, input.getFile())).toList(), input.getFile());
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Path jar = tmpLocation.resolve(input.getName() + ".jar");
        try (JarOutputStream jarOut = new JarOutputStream((OutputStream)new FileOutputStream(jar.toFile()), manifest);){
            Compiler.addToJar(compilerOutput.normalize(), compilerOutput.toFile(), jarOut);
        }
        FileUtils.deleteDirectory((File)compilerOutput.toFile());
        return Optional.of(new CompilationResult(jar, diagnosticCollector.getDiagnostics().stream().map(d -> new CompilationDiagnostic((Diagnostic<? extends JavaFileObject>)d, input.getFile())).toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToJar(Path root, File source, JarOutputStream target) throws IOException {
        Object relativePath = root.relativize(source.toPath().normalize()).toString().replace("\\", "/");
        try (BufferedInputStream in = null;){
            if (source.isDirectory()) {
                if (!((String)relativePath).isEmpty()) {
                    if (!((String)relativePath).endsWith("/")) {
                        relativePath = (String)relativePath + "/";
                    }
                    JarEntry entry = new JarEntry((String)relativePath);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                for (File nestedFile : source.listFiles()) {
                    Compiler.addToJar(root, nestedFile, target);
                }
            } else {
                int count;
                JarEntry entry = new JarEntry((String)relativePath);
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                in = new BufferedInputStream(new FileInputStream(source));
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    target.write(buffer, 0, count);
                }
                target.closeEntry();
            }
        }
    }
}

