/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.compiler;

import de.firemage.autograder.core.PathUtil;
import de.firemage.autograder.core.compiler.Compiler;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public record CompilationDiagnostic(String path, int line, int column, String message) {
    protected CompilationDiagnostic(Diagnostic<? extends JavaFileObject> diagnostic, Path root) {
        this(PathUtil.getSanitizedPath(diagnostic.getSource().toUri(), root), (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), diagnostic.getMessage(Compiler.COMPILER_LOCALE));
    }

    public static String formatMultiple(List<CompilationDiagnostic> diagnostics) {
        return diagnostics.stream().map(CompilationDiagnostic::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public String toString() {
        Object message = this.path;
        if ((long)this.line != -1L) {
            message = (String)message + ":" + this.line;
        }
        return (String)message + " " + this.message;
    }
}

