/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModifiable;

@ExecutableCheck(reportedProblems={ProblemType.UTILITY_CLASS_NOT_FINAL, ProblemType.UTILITY_CLASS_INVALID_CONSTRUCTOR})
public class UtilityClassCheck
extends IntegratedCheck {
    public UtilityClassCheck() {
        super(new LocalizedMessage("utility-desc"));
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> clazz) {
                if (clazz.isClass() && !clazz.getMethods().isEmpty() && clazz.getMethods().stream().allMatch(CtModifiable::isStatic) && clazz.getFields().stream().allMatch(f -> SpoonUtil.isEffectivelyFinal(staticAnalysis, f))) {
                    if (!clazz.isFinal()) {
                        UtilityClassCheck.this.addLocalProblem(clazz, new LocalizedMessage("utility-exp-final"), ProblemType.UTILITY_CLASS_NOT_FINAL);
                    }
                    if (clazz.getConstructors().stream().allMatch(CtElement::isImplicit)) {
                        UtilityClassCheck.this.addLocalProblem(clazz, new LocalizedMessage("utility-exp-constructor"), ProblemType.UTILITY_CLASS_INVALID_CONSTRUCTOR);
                    } else {
                        clazz.getConstructors().stream().filter(c -> !c.isImplicit() && !c.isPrivate() || !c.getParameters().isEmpty()).forEach(c -> UtilityClassCheck.this.addLocalProblem((CtElement)c, new LocalizedMessage("utility-exp-constructor"), ProblemType.UTILITY_CLASS_INVALID_CONSTRUCTOR));
                    }
                }
            }
        });
    }
}

