/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonStreamUtil;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtReturn;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.LIST_NOT_COPIED_IN_GETTER})
public class ListGetterSetterCheck
extends IntegratedCheck {
    public ListGetterSetterCheck() {
        super(new LocalizedMessage("list-getter-desc"));
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtReturn<?>>(){

            public void process(CtReturn<?> ret) {
                CtFieldRead read;
                CtField field;
                CtMethod parentMethod = (CtMethod)ret.getParent(CtMethod.class);
                if (parentMethod == null || !parentMethod.isPublic() || ret.getReturnedExpression() == null) {
                    return;
                }
                CtExpression returnedExpression = ret.getReturnedExpression();
                if (ListGetterSetterCheck.this.isMutableCollection(returnedExpression.getType()) && returnedExpression instanceof CtFieldRead && (field = (read = (CtFieldRead)returnedExpression).getVariable().getFieldDeclaration()).isPrivate() && ListGetterSetterCheck.this.wasMutablyAssigned(staticAnalysis, field)) {
                    ListGetterSetterCheck.this.addLocalProblem(ret, new LocalizedMessage("list-getter-exp"), ProblemType.LIST_NOT_COPIED_IN_GETTER);
                }
            }
        });
    }

    private boolean isMutableCollection(CtTypeReference<?> type) {
        String name = type.getQualifiedName();
        return name.equals("java.util.List") || name.equals("java.util.ArrayList") || name.equals("java.util.LinkedList") || name.equals("java.util.Map") || name.equals("java.util.HashMap") || name.equals("java.util.TreeMap") || name.equals("java.util.Set") || name.equals("java.util.HashSet") || name.equals("java.util.LinkedHashSet") || name.equals("java.util.TreeSet");
    }

    private boolean wasMutablyAssigned(StaticAnalysis analysis, final CtField<?> field) {
        if (field.getDefaultExpression() != null && this.isMutableAssignee(field.getDefaultExpression())) {
            return true;
        }
        var processor = new AbstractProcessor<CtAssignment<?, ?>>(){
            boolean mutablyAssigned = false;

            public void process(CtAssignment<?, ?> write) {
                CtFieldAccess ref;
                CtExpression ctExpression = write.getAssigned();
                if (ctExpression instanceof CtFieldAccess && (ref = (CtFieldAccess)ctExpression).getVariable().getFieldDeclaration().equals((Object)field) && ListGetterSetterCheck.this.isMutableAssignee(write.getAssignment())) {
                    this.mutablyAssigned = true;
                }
            }
        };
        analysis.processWith(processor);
        return processor.mutablyAssigned;
    }

    private boolean isMutableAssignee(CtExpression<?> expression) {
        if (expression instanceof CtInvocation) {
            CtInvocation invocation = (CtInvocation)expression;
            return !SpoonUtil.isStaticCallTo(invocation, "java.util.List", "of") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Set", "of") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Map", "of") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Collections", "unmodifiableList") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Collections", "unmodifiableSet") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Collections", "unmodifiableSortedSet") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Collections", "unmodifiableMap") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Collections", "unmodifiableSortedMap") && !SpoonUtil.isStaticCallTo(invocation, "java.util.Collections", "unmodifiableCollection") && (!SpoonStreamUtil.isStreamOperation(invocation) || !invocation.getExecutable().getSimpleName().equals("toList"));
        }
        return expression instanceof CtConstructorCall;
    }
}

