/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;

@ExecutableCheck(reportedProblems={ProblemType.CONSTANT_IN_INTERFACE, ProblemType.DO_NOT_HAVE_CONSTANTS_CLASS, ProblemType.STATIC_INTERFACE, ProblemType.STATIC_METHOD_IN_INTERFACE})
public class InterfaceBadPractices
extends IntegratedCheck {
    public InterfaceBadPractices() {
        super(new LocalizedMessage("interface-bad-practices-desc"));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInterface<?>>(){

            public void process(CtInterface<?> ctInterface) {
                List fields = ctInterface.getFields();
                Set methods = ctInterface.getMethods();
                if (methods.isEmpty() && !fields.isEmpty()) {
                    InterfaceBadPractices.this.addLocalProblem(ctInterface, new LocalizedMessage("constants-class-exp"), ProblemType.DO_NOT_HAVE_CONSTANTS_CLASS);
                } else if (!fields.isEmpty()) {
                    for (CtField field : fields) {
                        InterfaceBadPractices.this.addLocalProblem((CtElement)field, new LocalizedMessage("constants-interfaces-exp"), ProblemType.CONSTANT_IN_INTERFACE);
                    }
                }
                for (CtMethod method : methods) {
                    if (!method.isStatic()) continue;
                    InterfaceBadPractices.this.addLocalProblem((CtElement)method, new LocalizedMessage("interface-static-method-exp"), ProblemType.STATIC_METHOD_IN_INTERFACE);
                }
                if (ctInterface.isStatic()) {
                    InterfaceBadPractices.this.addLocalProblem(ctInterface, new LocalizedMessage("interface-static-exp"), ProblemType.STATIC_INTERFACE);
                }
            }
        });
    }
}

