/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.naming;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;

@ExecutableCheck(reportedProblems={ProblemType.SINGLE_LETTER_LOCAL_NAME, ProblemType.IDENTIFIER_IS_ABBREVIATED_TYPE})
public class VariablesHaveDescriptiveNamesCheck
extends IntegratedCheck {
    private static final Set<String> ALLOWED_ABBREVIATIONS = Set.of("ui");

    public VariablesHaveDescriptiveNamesCheck() {
        super(new LocalizedMessage("variable-name-desc"));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtVariable<?>>(){

            public void process(CtVariable<?> variable) {
                CtMethod method;
                CtElement ctElement;
                if (variable instanceof CtCatchVariable || VariablesHaveDescriptiveNamesCheck.this.isLambdaParameter(variable)) {
                    return;
                }
                if (variable.getSimpleName().equals("o") && (ctElement = variable.getParent()) instanceof CtMethod && (SpoonUtil.isEqualsMethod(method = (CtMethod)ctElement) || SpoonUtil.isCompareToMethod(method))) {
                    return;
                }
                if (variable.getSimpleName().length() == 1 && !VariablesHaveDescriptiveNamesCheck.this.isAllowedLoopCounter(variable) && !VariablesHaveDescriptiveNamesCheck.this.isCoordinate(variable)) {
                    VariablesHaveDescriptiveNamesCheck.this.addLocalProblem(variable, new LocalizedMessage("variable-name-exp-single-letter", Map.of("name", variable.getSimpleName())), ProblemType.SINGLE_LETTER_LOCAL_NAME);
                } else if (VariablesHaveDescriptiveNamesCheck.this.isTypeAbbreviation(variable)) {
                    VariablesHaveDescriptiveNamesCheck.this.addLocalProblem(variable, new LocalizedMessage("variable-name-exp-type", Map.of("name", variable.getSimpleName())), ProblemType.IDENTIFIER_IS_ABBREVIATED_TYPE);
                }
            }
        });
    }

    private boolean isLambdaParameter(CtVariable<?> variable) {
        return variable instanceof CtParameter && variable.getParent() instanceof CtLambda;
    }

    private boolean isCoordinate(CtVariable<?> variable) {
        return variable.getSimpleName().equals("x") || variable.getSimpleName().equals("y");
    }

    private boolean isAllowedLoopCounter(CtVariable<?> variable) {
        return (variable.getRoleInParent() == CtRole.FOR_INIT || variable.getRoleInParent() == CtRole.FOREACH_VARIABLE) && SpoonUtil.isPrimitiveNumeric(variable.getType());
    }

    private boolean isTypeAbbreviation(CtVariable<?> variable) {
        if (variable.getType().isPrimitive()) {
            return false;
        }
        if (ALLOWED_ABBREVIATIONS.contains(variable.getSimpleName().toLowerCase())) {
            return false;
        }
        String name = variable.getSimpleName();
        String type = variable.getType().getSimpleName();
        String[] parts = StringUtils.splitByCharacterTypeCamelCase((String)type);
        if (parts[0].length() >= 4 && name.length() <= 3 && parts[0].toLowerCase().indexOf(name) == 0) {
            return true;
        }
        if (parts.length == name.length()) {
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].toLowerCase().charAt(0) == name.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

