/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTextBlock;

@ExecutableCheck(reportedProblems={ProblemType.SYSTEM_SPECIFIC_LINE_BREAK})
public class WrongLineBreakCheck
extends IntegratedCheck {
    public WrongLineBreakCheck() {
        super(new LocalizedMessage("system-dependent-linebreak-desc"));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtLiteral<?>>(){

            /*
             * Enabled aggressive block sorting
             */
            public void process(CtLiteral<?> literal) {
                Object object = literal.getValue();
                if (object instanceof String) {
                    String value = (String)object;
                    if (!(literal instanceof CtTextBlock) && (value.contains("\n") || value.contains("\r") || value.contains("\\n") || value.contains("\\r"))) {
                        WrongLineBreakCheck.this.addLocalProblem(literal, new LocalizedMessage("system-dependent-linebreak-exp"), ProblemType.SYSTEM_SPECIFIC_LINE_BREAK);
                        return;
                    }
                }
                if (!((object = literal.getValue()) instanceof Character)) return;
                Character value = (Character)object;
                if (value.charValue() != '\n') {
                    if (value.charValue() != '\r') return;
                }
                WrongLineBreakCheck.this.addLocalProblem(literal, new LocalizedMessage("system-dependent-linebreak-exp"), ProblemType.SYSTEM_SPECIFIC_LINE_BREAK);
            }
        });
    }
}

