/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;

@ExecutableCheck(reportedProblems={ProblemType.FIELD_SHOULD_BE_FINAL})
public class FieldShouldBeFinalCheck
extends IntegratedCheck {
    public FieldShouldBeFinalCheck() {
        super(new LocalizedMessage("field-final-desc"));
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<?>>(){

            public void process(CtField<?> field) {
                boolean hasWrite;
                Set parentConstructors;
                if (field.isFinal()) {
                    return;
                }
                CtType ctType = field.getDeclaringType();
                if (ctType instanceof CtClass) {
                    CtClass clazz = (CtClass)ctType;
                    parentConstructors = clazz.getConstructors();
                } else {
                    parentConstructors = Set.of();
                }
                boolean bl = hasWrite = staticAnalysis.getModel().filterChildren(c -> {
                    CtExecutable e;
                    return c instanceof CtExecutable && !parentConstructors.contains(e = (CtExecutable)c);
                }).filterChildren(e -> e.filterChildren(c -> {
                    CtFieldWrite w;
                    return c instanceof CtFieldWrite && (w = (CtFieldWrite)c).getVariable().equals((Object)field.getReference());
                }).first() != null).first() != null;
                if (!hasWrite) {
                    FieldShouldBeFinalCheck.this.addLocalProblem(field, new LocalizedMessage("field-final-exp", Map.of("name", field.getSimpleName())), ProblemType.FIELD_SHOULD_BE_FINAL);
                }
            }
        });
    }
}

