/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.exceptions;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.ExceptionUtil;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtThrow;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.EXCEPTION_WITHOUT_MESSAGE})
public class ExceptionMessageCheck
extends IntegratedCheck {
    public ExceptionMessageCheck() {
        super(new LocalizedMessage("exception-message-desc"));
    }

    private static boolean isExceptionWithoutMessage(CtExpression<?> expression) {
        CtConstructorCall ctorCall;
        return expression instanceof CtConstructorCall && ExceptionUtil.isRuntimeException((ctorCall = (CtConstructorCall)expression).getType()) && ctorCall.getArguments().stream().noneMatch(e -> ExceptionMessageCheck.isNonBlankString((CtExpression)e));
    }

    private static boolean isNonBlankString(CtExpression<?> expression) {
        CtLiteral literal;
        if (!SpoonUtil.isString(expression.getType())) {
            return false;
        }
        return !(expression instanceof CtLiteral) || !((String)(literal = (CtLiteral)expression).getValue()).isBlank();
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtThrow>(){

            public void process(CtThrow throwStmt) {
                if (ExceptionMessageCheck.isExceptionWithoutMessage(throwStmt.getThrownExpression())) {
                    ExceptionMessageCheck.this.addLocalProblem((CtElement)throwStmt, new LocalizedMessage("exception-message-exp"), ProblemType.EXCEPTION_WITHOUT_MESSAGE);
                }
            }
        });
    }
}

