/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_SELF_ASSIGNMENT})
public class SelfAssignmentCheck
extends IntegratedCheck {
    public SelfAssignmentCheck() {
        super(new LocalizedMessage("self-assignment-desc"));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtAssignment<?, ?>>(){

            public void process(CtAssignment<?, ?> assignment) {
                CtExpression ctExpression = assignment.getAssignment();
                if (ctExpression instanceof CtVariableRead) {
                    CtVariableRead read = (CtVariableRead)ctExpression;
                    ctExpression = assignment.getAssigned();
                    if (ctExpression instanceof CtVariableWrite) {
                        CtVariableWrite write = (CtVariableWrite)ctExpression;
                        if (read.getVariable().equals((Object)write.getVariable())) {
                            SelfAssignmentCheck.this.addLocalProblem(assignment, new LocalizedMessage("self-assignment-exp", Map.of("lhs", assignment.getAssigned(), "rhs", assignment.getAssignment())), ProblemType.REDUNDANT_SELF_ASSIGNMENT);
                        }
                    }
                }
            }
        });
    }
}

