/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.REPEATED_MATH_OPERATION})
public class RepeatedMathOperationCheck
extends IntegratedCheck {
    private static final Map<BinaryOperatorKind, Integer> OCCURRENCE_THRESHOLDS = Map.of(BinaryOperatorKind.PLUS, 2, BinaryOperatorKind.MUL, 3);

    public RepeatedMathOperationCheck() {
        super(new LocalizedMessage("repeated-math-operation"));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtBinaryOperator<?>>(){

            public void process(CtBinaryOperator<?> operator) {
                CtBinaryOperator parent;
                if (!OCCURRENCE_THRESHOLDS.containsKey(operator.getKind())) {
                    return;
                }
                CtElement ctElement = operator.getParent();
                if (ctElement instanceof CtBinaryOperator && (parent = (CtBinaryOperator)ctElement).getKind() == operator.getKind()) {
                    return;
                }
                Map<CtVariableReference<?>, Integer> occurrences = RepeatedMathOperationCheck.this.countOccurrences((CtExpression<?>)operator, operator.getKind());
                Optional<Map.Entry> variable = occurrences.entrySet().stream().filter(e -> (Integer)e.getValue() >= OCCURRENCE_THRESHOLDS.get(operator.getKind())).max(Comparator.comparingInt(Map.Entry::getValue));
                variable.ifPresent(ctVariableReferenceIntegerEntry -> RepeatedMathOperationCheck.this.addLocalProblem((CtElement)operator, new LocalizedMessage("repeated-math-operation-" + operator.getKind().toString().toLowerCase(), Map.of("var", ((CtVariableReference)ctVariableReferenceIntegerEntry.getKey()).getSimpleName(), "count", (Serializable)ctVariableReferenceIntegerEntry.getValue())), ProblemType.REPEATED_MATH_OPERATION));
            }
        });
    }

    private Map<CtVariableReference<?>, Integer> countOccurrences(CtExpression<?> expression, BinaryOperatorKind kind) {
        CtBinaryOperator operator;
        if (expression instanceof CtVariableRead) {
            CtVariableRead read = (CtVariableRead)expression;
            return Map.of(read.getVariable(), 1);
        }
        if (expression instanceof CtBinaryOperator && (operator = (CtBinaryOperator)expression).getKind() == kind) {
            if (SpoonUtil.isString(operator.getLeftHandOperand().getType()) || SpoonUtil.isString(operator.getRightHandOperand().getType())) {
                return Map.of();
            }
            return this.mergeOccurrenceMaps(this.countOccurrences(operator.getLeftHandOperand(), kind), this.countOccurrences(operator.getRightHandOperand(), kind));
        }
        return Map.of();
    }

    private Map<CtVariableReference<?>, Integer> mergeOccurrenceMaps(Map<CtVariableReference<?>, Integer> map1, Map<CtVariableReference<?>, Integer> map2) {
        return Stream.concat(map1.entrySet().stream(), map2.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
    }
}

