/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_NEGATION})
public class RedundantNegationCheck
extends IntegratedCheck {
    public RedundantNegationCheck() {
        super(new LocalizedMessage("redundant-neg-desc"));
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtUnaryOperator<?>>(){

            public void process(CtUnaryOperator<?> op) {
                CtBinaryOperator inner;
                if (op.getKind() != UnaryOperatorKind.NOT) {
                    return;
                }
                CtExpression ctExpression = op.getOperand();
                if (ctExpression instanceof CtBinaryOperator && (inner = (CtBinaryOperator)ctExpression).getKind() == BinaryOperatorKind.EQ) {
                    CtBinaryOperator fixed = staticAnalysis.getFactory().createBinaryOperator(inner.getLeftHandOperand(), inner.getRightHandOperand(), BinaryOperatorKind.NE);
                    RedundantNegationCheck.this.addLocalProblem(op, new LocalizedMessage("redundant-neg-exp", Map.of("original", op.toString(), "fixed", fixed)), ProblemType.REDUNDANT_NEGATION);
                }
            }
        });
    }
}

