/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_IF_FOR_BOOLEAN})
public class RedundantIfForBooleanCheck
extends IntegratedCheck {
    public RedundantIfForBooleanCheck() {
        super(new LocalizedMessage("redundant-if-for-bool-desc"));
    }

    private LocalizedMessage formatReturnProblem(CtExpression<?> expression, boolean negate) {
        return new LocalizedMessage("redundant-if-for-bool-exp-return", Map.of("exp", (negate ? "!" : "") + String.valueOf(expression)));
    }

    private LocalizedMessage formatAssignProblem(CtExpression<?> expression, CtExpression<?> target, boolean negate) {
        return new LocalizedMessage("redundant-if-for-bool-exp-return", Map.of("exp", (negate ? "!" : "") + String.valueOf(expression), "target", target.toString()));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtBlock<?>>(){

            public void process(CtBlock<?> block) {
                List<CtStatement> statements = SpoonUtil.getEffectiveStatements(block);
                for (int i = 0; i < statements.size(); ++i) {
                    CtStatement statement = statements.get(i);
                    if (!(statement instanceof CtIf)) continue;
                    CtIf ifStmt = (CtIf)statement;
                    if (ifStmt.getElseStatement() != null) {
                        RedundantIfForBooleanCheck.this.checkIfElseReturn(ifStmt.getCondition(), SpoonUtil.unwrapStatement(ifStmt.getThenStatement()), SpoonUtil.unwrapStatement(ifStmt.getElseStatement()));
                        RedundantIfForBooleanCheck.this.checkIfElseAssign(ifStmt.getCondition(), SpoonUtil.unwrapStatement(ifStmt.getThenStatement()), SpoonUtil.unwrapStatement(ifStmt.getElseStatement()));
                        continue;
                    }
                    if (i + 1 >= statements.size()) continue;
                    RedundantIfForBooleanCheck.this.checkIfElseReturn(ifStmt.getCondition(), SpoonUtil.unwrapStatement(ifStmt.getThenStatement()), statements.get(i + 1));
                }
            }
        });
    }

    private void checkIfElseReturn(CtExpression<?> condition, CtStatement thenStmt, CtStatement elseStmt) {
        if (thenStmt instanceof CtReturn) {
            CtReturn thenRet = (CtReturn)thenStmt;
            if (elseStmt instanceof CtReturn) {
                CtReturn elseRet = (CtReturn)elseStmt;
                Optional<Boolean> thenValue = SpoonUtil.tryGetBooleanLiteral(thenRet.getReturnedExpression());
                Optional<Boolean> elseValue = SpoonUtil.tryGetBooleanLiteral(elseRet.getReturnedExpression());
                if (thenValue.isPresent() && elseValue.isPresent()) {
                    if (thenValue.get().booleanValue() && !elseValue.get().booleanValue()) {
                        this.addLocalProblem((CtElement)condition, this.formatReturnProblem(condition, false), ProblemType.REDUNDANT_IF_FOR_BOOLEAN);
                    } else if (!thenValue.get().booleanValue() && elseValue.get().booleanValue()) {
                        this.addLocalProblem((CtElement)condition, this.formatReturnProblem(condition, true), ProblemType.REDUNDANT_IF_FOR_BOOLEAN);
                    }
                }
            }
        }
    }

    private void checkIfElseAssign(CtExpression<?> condition, CtStatement thenStmt, CtStatement elseStmt) {
        if (thenStmt instanceof CtAssignment) {
            CtAssignment thenAssign = (CtAssignment)thenStmt;
            if (elseStmt instanceof CtAssignment) {
                CtAssignment elseAssign = (CtAssignment)elseStmt;
                Optional<Boolean> thenValue = SpoonUtil.tryGetBooleanLiteral(thenAssign.getAssignment());
                Optional<Boolean> elseValue = SpoonUtil.tryGetBooleanLiteral(elseAssign.getAssignment());
                if (thenValue.isPresent() && elseValue.isPresent() && thenAssign.getAssigned().equals((Object)elseAssign.getAssigned())) {
                    if (thenValue.get().booleanValue() && !elseValue.get().booleanValue()) {
                        this.addLocalProblem((CtElement)condition, this.formatAssignProblem(condition, thenAssign.getAssigned(), false), ProblemType.REDUNDANT_IF_FOR_BOOLEAN);
                    } else if (!thenValue.get().booleanValue() && elseValue.get().booleanValue()) {
                        this.addLocalProblem((CtElement)condition, this.formatAssignProblem(condition, thenAssign.getAssigned(), true), ProblemType.REDUNDANT_IF_FOR_BOOLEAN);
                    }
                }
            }
        }
    }
}

