/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.scope.Scope;
import de.firemage.autograder.core.integrated.scope.ScopedVisitor;
import de.firemage.autograder.core.integrated.scope.value.ArrayValue;
import de.firemage.autograder.core.integrated.scope.value.Value;
import de.firemage.autograder.core.integrated.scope.value.VariableValue;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_ARRAY_INIT})
public class RedundantArrayInit
extends IntegratedCheck {
    public RedundantArrayInit() {
        super(new LocalizedMessage("redundant-array-init-desc"));
    }

    private <L, R> void checkAssignment(L lhs, CtExpression<R> rhs, CtElement element, Scope scope) {
        if (lhs instanceof CtArrayWrite) {
            CtArrayWrite arrayWrite = (CtArrayWrite)lhs;
            CtVariableAccess<?> read = SpoonUtil.getVariableFromArray(arrayWrite);
            CtVariableReference variableName = read.getVariable();
            Value value = scope.get(variableName);
            if (!(value instanceof ArrayValue)) {
                throw new IllegalStateException("Expected array value for " + String.valueOf(variableName));
            }
            ArrayValue arrayValue = (ArrayValue)value;
            Value currentValue = arrayValue.get(VariableValue.fromExpression(arrayWrite.getIndexExpression()), scope);
            if (currentValue == null) {
                return;
            }
            Value rhsValue = scope.resolve(rhs);
            currentValue.toLiteral().ifPresent(literal -> {
                CtLiteral rhsLiteralValue = rhsValue.toLiteral().orElse(null);
                if (rhsLiteralValue != null && SpoonUtil.areLiteralsEqual(rhsLiteralValue, literal)) {
                    this.addLocalProblem(element, new LocalizedMessage("redundant-array-init-desc"), ProblemType.REDUNDANT_ARRAY_INIT);
                }
            });
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new ScopedVisitor(){

            @Override
            public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
                RedundantArrayInit.this.checkAssignment(assignment.getAssigned(), assignment.getAssignment(), (CtElement)assignment, this.getScope());
                super.visitCtAssignment(assignment);
            }
        });
    }
}

