/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtType;

@ExecutableCheck(reportedProblems={ProblemType.JAVADOC_UNEXPECTED_TAG, ProblemType.INVALID_AUTHOR_TAG})
public class TypeJavadocCheck
extends IntegratedCheck {
    private static final List<CtJavaDocTag.TagType> VALID_TAGS = List.of(CtJavaDocTag.TagType.SEE, CtJavaDocTag.TagType.UNKNOWN, CtJavaDocTag.TagType.DEPRECATED, CtJavaDocTag.TagType.VERSION, CtJavaDocTag.TagType.AUTHOR, CtJavaDocTag.TagType.SINCE);
    private final Pattern pattern;

    public TypeJavadocCheck() {
        this("u(\\w){4}");
    }

    public TypeJavadocCheck(String regex) {
        super(new LocalizedMessage("javadoc-type-desc"));
        this.pattern = Pattern.compile(regex);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtType<?>>(){

            public void process(CtType<?> type) {
                Optional<CtJavaDoc> javadoc = SpoonUtil.getJavadoc(type);
                if (javadoc.isEmpty()) {
                    return;
                }
                TypeJavadocCheck.this.checkValidTags(javadoc.get(), type);
                TypeJavadocCheck.this.checkValidAuthor(javadoc.get());
            }
        });
    }

    private void checkValidTags(CtJavaDoc javadoc, CtType<?> type) {
        for (CtJavaDocTag tag : javadoc.getTags()) {
            if (VALID_TAGS.contains(tag.getType()) || tag.getType() == CtJavaDocTag.TagType.PARAM && type instanceof CtRecord) continue;
            this.addLocalProblem((CtElement)javadoc, new LocalizedMessage("javadoc-type-exp-unexpected-tag", Map.of("tag", tag.getType().getName())), ProblemType.JAVADOC_UNEXPECTED_TAG);
        }
    }

    private void checkValidAuthor(CtJavaDoc javadoc) {
        Optional<CtJavaDocTag> authorTag = javadoc.getTags().stream().filter(tag -> tag.getType() == CtJavaDocTag.TagType.AUTHOR).findAny();
        if (authorTag.isPresent() && !this.pattern.matcher(authorTag.get().getContent().trim()).matches()) {
            this.addLocalProblem((CtElement)javadoc, new LocalizedMessage("javadoc-type-exp-invalid-author", Map.of("author", authorTag.get().getContent().trim())), ProblemType.INVALID_AUTHOR_TAG);
        }
    }
}

