/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtComment;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.COMMENTED_OUT_CODE})
public class CommentedOutCodeCheck
extends IntegratedCheck {
    private static final LocalizedMessage DESCRIPTION = new LocalizedMessage("commented-out-code-desc");

    public CommentedOutCodeCheck() {
        super(DESCRIPTION);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtComment>(){

            public void process(CtComment comment) {
                CtComment.CommentType type = comment.getCommentType();
                String content = comment.getContent().trim();
                if (type == CtComment.CommentType.INLINE) {
                    if (content.endsWith(";") || content.equals("{") || content.equals("}")) {
                        CommentedOutCodeCheck.this.addLocalProblem((CtElement)comment, new LocalizedMessage("commented-out-code-exp"), ProblemType.COMMENTED_OUT_CODE);
                    }
                } else if (type == CtComment.CommentType.BLOCK && (content.contains(";") || content.contains("=") || content.contains("{") || content.contains("}"))) {
                    CommentedOutCodeCheck.this.addLocalProblem((CtElement)comment, new LocalizedMessage("commented-out-code-exp"), ProblemType.COMMENTED_OUT_CODE);
                }
            }
        });
    }
}

