/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.api.LanguageDetector;
import com.github.pemistahl.lingua.api.LanguageDetectorBuilder;
import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.IntegratedInCodeProblem;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.ToDoubleFunction;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.INVALID_COMMENT_LANGUAGE, ProblemType.INCONSISTENT_COMMENT_LANGUAGE})
public class CommentLanguageCheck
extends IntegratedCheck {
    private static final LocalizedMessage DESCRIPTION = new LocalizedMessage("comment-language-desc");
    private final LanguageDetector detector;

    public CommentLanguageCheck() {
        this(0.075);
    }

    public CommentLanguageCheck(double threshold) {
        super(DESCRIPTION);
        this.detector = LanguageDetectorBuilder.fromAllLanguages().withMinimumRelativeDistance(threshold).build();
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        final ArrayList englishComments = new ArrayList();
        final ArrayList germanComments = new ArrayList();
        staticAnalysis.processWith(new AbstractProcessor<CtComment>(){

            public void process(CtComment comment) {
                CommentLanguageResult language = CommentLanguageResult.detect(comment, CommentLanguageCheck.this.detector);
                switch (language.language) {
                    case ENGLISH: {
                        englishComments.add(language);
                        break;
                    }
                    case GERMAN: {
                        germanComments.add(language);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    default: {
                        CommentLanguageCheck.this.addLocalProblem((CtElement)comment, new LocalizedMessage("comment-language-exp-invalid", Map.of("lang", language.language.name())), ProblemType.INVALID_COMMENT_LANGUAGE);
                    }
                }
            }
        });
        if (!englishComments.isEmpty() && !germanComments.isEmpty()) {
            CtComment bestEnglish = englishComments.stream().max(Comparator.comparingDouble((ToDoubleFunction<CommentLanguageResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$check$0(de.firemage.autograder.core.check.comment.CommentLanguageCheck$CommentLanguageResult ), (Lde/firemage/autograder/core/check/comment/CommentLanguageCheck$CommentLanguageResult;)D)())).get().comment;
            CodePosition englishPosition = IntegratedInCodeProblem.mapSourceToCode((CtElement)bestEnglish, this.getRoot());
            CtComment bestGerman = germanComments.stream().max(Comparator.comparingDouble((ToDoubleFunction<CommentLanguageResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$check$1(de.firemage.autograder.core.check.comment.CommentLanguageCheck$CommentLanguageResult ), (Lde/firemage/autograder/core/check/comment/CommentLanguageCheck$CommentLanguageResult;)D)())).get().comment;
            CodePosition germanPosition = IntegratedInCodeProblem.mapSourceToCode((CtElement)bestGerman, this.getRoot());
            this.addLocalProblem((CtElement)bestEnglish, new LocalizedMessage("comment-language-exp-english", Map.of("path", germanPosition.file().toString(), "line", String.valueOf(germanPosition.startLine()))), ProblemType.INCONSISTENT_COMMENT_LANGUAGE);
            this.addLocalProblem((CtElement)bestGerman, new LocalizedMessage("comment-language-exp-german", Map.of("path", englishPosition.file().toString(), "line", String.valueOf(englishPosition.startLine()))), ProblemType.INCONSISTENT_COMMENT_LANGUAGE);
        }
    }

    private static /* synthetic */ double lambda$check$1(CommentLanguageResult a) {
        return a.confidence;
    }

    private static /* synthetic */ double lambda$check$0(CommentLanguageResult a) {
        return a.confidence;
    }

    private record CommentLanguageResult(CtComment comment, Language language, double confidence) {
        public static CommentLanguageResult detect(CtComment comment, LanguageDetector detector) {
            StringBuilder content = new StringBuilder(comment.getContent().replace("@see", ""));
            if (comment instanceof CtJavaDoc) {
                CtJavaDoc javadoc = (CtJavaDoc)comment;
                for (CtJavaDocTag tag : javadoc.getTags()) {
                    if (tag.getType() != CtJavaDocTag.TagType.PARAM && tag.getType() != CtJavaDocTag.TagType.RETURN && tag.getType() != CtJavaDocTag.TagType.THROWS) continue;
                    content.append(". ").append(tag.getContent().replace("@see", ""));
                }
            }
            if (content.toString().split(" +").length <= 3) {
                return new CommentLanguageResult(comment, Language.UNKNOWN, 0.0);
            }
            Language language = detector.detectLanguageOf(content.toString());
            SortedMap confidences = detector.computeLanguageConfidenceValues(content.toString());
            double englishConfidence = confidences.getOrDefault(Language.ENGLISH, 0.0);
            double germanConfidence = confidences.getOrDefault(Language.GERMAN, 0.0);
            return new CommentLanguageResult(comment, language, Math.abs(englishConfidence - germanConfidence));
        }
    }
}

