/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;

@ExecutableCheck(reportedProblems={ProblemType.STRING_IS_EMPTY_REIMPLEMENTED})
public class StringIsEmptyReimplementationCheck
extends IntegratedCheck {
    private static final LocalizedMessage DESCRIPTION = new LocalizedMessage("string-is-empty-desc");

    public StringIsEmptyReimplementationCheck() {
        super(DESCRIPTION);
    }

    private static LocalizedMessage formatExplanation(CtElement element) {
        return new LocalizedMessage("string-is-empty-exp-emptiness", Map.of("exp", element.toString()));
    }

    private static LocalizedMessage formatNegatedExplanation(CtElement element) {
        return new LocalizedMessage("string-is-empty-exp-non-emptiness", Map.of("exp", element.toString()));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInvocation<?>>(){

            public void process(CtInvocation<?> invocation) {
                if (invocation.getTarget() == null) {
                    return;
                }
                if (SpoonUtil.isString(invocation.getTarget().getType())) {
                    if (StringIsEmptyReimplementationCheck.this.equalsWithEmptyString(invocation)) {
                        StringIsEmptyReimplementationCheck.this.addLocalProblem(invocation, StringIsEmptyReimplementationCheck.formatExplanation(invocation), ProblemType.STRING_IS_EMPTY_REIMPLEMENTED);
                    } else if (StringIsEmptyReimplementationCheck.this.lengthZeroCheck(invocation)) {
                        StringIsEmptyReimplementationCheck.this.addLocalProblem(invocation.getParent(), StringIsEmptyReimplementationCheck.formatExplanation(invocation.getParent()), ProblemType.STRING_IS_EMPTY_REIMPLEMENTED);
                    } else if (StringIsEmptyReimplementationCheck.this.lengthGreaterThanZeroCheck(invocation)) {
                        StringIsEmptyReimplementationCheck.this.addLocalProblem(invocation.getParent(), StringIsEmptyReimplementationCheck.formatNegatedExplanation(invocation.getParent()), ProblemType.STRING_IS_EMPTY_REIMPLEMENTED);
                    }
                }
            }
        });
    }

    private boolean equalsWithEmptyString(CtInvocation<?> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        return executable.getSignature().equals("equals(java.lang.Object)") && SpoonUtil.isStringLiteral((CtExpression)invocation.getArguments().get(0), "");
    }

    private boolean lengthZeroCheck(CtInvocation<?> invocation) {
        CtBinaryOperator operator;
        CtElement ctElement;
        CtExecutableReference executable = invocation.getExecutable();
        return executable.getSignature().equals("length()") && (ctElement = invocation.getParent()) instanceof CtBinaryOperator && (operator = (CtBinaryOperator)ctElement).getKind().equals((Object)BinaryOperatorKind.EQ) && (SpoonUtil.isIntegerLiteral(operator.getLeftHandOperand(), 0) || SpoonUtil.isIntegerLiteral(operator.getRightHandOperand(), 0));
    }

    private boolean lengthGreaterThanZeroCheck(CtInvocation<?> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        if (!executable.getSignature().equals("length()")) {
            return false;
        }
        CtElement ctElement = invocation.getParent();
        if (ctElement instanceof CtBinaryOperator) {
            CtBinaryOperator operator = (CtBinaryOperator)ctElement;
            return switch (operator.getKind()) {
                case BinaryOperatorKind.EQ -> {
                    if (SpoonUtil.isIntegerLiteral(operator.getLeftHandOperand(), 0) || SpoonUtil.isIntegerLiteral(operator.getRightHandOperand(), 0)) {
                        yield true;
                    }
                    yield false;
                }
                case BinaryOperatorKind.GT -> SpoonUtil.isIntegerLiteral(operator.getRightHandOperand(), 0);
                case BinaryOperatorKind.GE -> SpoonUtil.isIntegerLiteral(operator.getRightHandOperand(), 1);
                case BinaryOperatorKind.LT -> SpoonUtil.isIntegerLiteral(operator.getLeftHandOperand(), 0);
                case BinaryOperatorKind.LE -> SpoonUtil.isIntegerLiteral(operator.getLeftHandOperand(), 1);
                default -> false;
            };
        }
        return false;
    }
}

