/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.DEPRECATED_COLLECTION_USED})
public class OldCollectionCheck
extends IntegratedCheck {
    public static final LocalizedMessage DESCRIPTION = new LocalizedMessage("old-collection-desc");

    public OldCollectionCheck() {
        super(DESCRIPTION);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtConstructorCall<?>>(){

            public void process(CtConstructorCall call) {
                String type;
                switch (type = call.getType().getQualifiedName()) {
                    case "java.util.Vector": {
                        OldCollectionCheck.this.addLocalProblem((CtElement)call, new LocalizedMessage("old-collection-exp-vector"), ProblemType.DEPRECATED_COLLECTION_USED);
                        break;
                    }
                    case "java.util.Hashtable": {
                        OldCollectionCheck.this.addLocalProblem((CtElement)call, new LocalizedMessage("old-collection-exp-hashtable"), ProblemType.DEPRECATED_COLLECTION_USED);
                        break;
                    }
                    case "java.util.Stack": {
                        OldCollectionCheck.this.addLocalProblem((CtElement)call, new LocalizedMessage("old-collection-exp-stack"), ProblemType.DEPRECATED_COLLECTION_USED);
                    }
                }
            }
        });
    }
}

