/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core;

import de.firemage.autograder.core.LinterException;
import de.firemage.autograder.core.LinterStatus;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.Check;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.check.general.CopyPasteCheck;
import de.firemage.autograder.core.compiler.CompilationResult;
import de.firemage.autograder.core.compiler.Compiler;
import de.firemage.autograder.core.cpd.CPDLinter;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.core.integrated.IntegratedAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.pmd.PMDCheck;
import de.firemage.autograder.core.pmd.PMDLinter;
import de.firemage.autograder.core.spotbugs.SpotbugsCheck;
import de.firemage.autograder.core.spotbugs.SpotbugsLinter;
import fluent.bundle.FluentBundle;
import fluent.bundle.FluentResource;
import fluent.functions.FluentFunctionFactory;
import fluent.functions.icu.ICUFunctionFactory;
import fluent.syntax.parser.FTLParser;
import fluent.syntax.parser.FTLStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Linter {
    private final FluentBundle fluentBundle;

    public Linter(Locale locale) {
        String filename = switch (locale.getLanguage()) {
            case "de" -> "/strings.de.ftl";
            case "en" -> "/strings.en.ftl";
            default -> throw new IllegalArgumentException("No translation available for the locale " + String.valueOf(locale));
        };
        try {
            FluentResource resource = FTLParser.parse((FTLStream)FTLStream.of((String)new String(this.getClass().getResourceAsStream(filename).readAllBytes(), StandardCharsets.UTF_8)));
            this.fluentBundle = FluentBundle.builder((Locale)locale, (FluentFunctionFactory)ICUFunctionFactory.INSTANCE).addResource(resource).build();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<Problem> checkFile(UploadedFile file, Path tmpLocation, Path tests, List<ProblemType> problemsToReport, Consumer<LinterStatus> statusConsumer, boolean disableDynamicAnalysis) throws LinterException, IOException, InterruptedException {
        return this.checkFile(file, tmpLocation, tests, problemsToReport, this.findChecksForProblemTypes(problemsToReport), statusConsumer, disableDynamicAnalysis);
    }

    public List<Problem> checkFile(UploadedFile file, Path tmpLocation, Path tests, List<ProblemType> problemsToReport, List<Check> checks, Consumer<LinterStatus> statusConsumer, boolean disableDynamicAnalysis) throws LinterException, InterruptedException, IOException {
        statusConsumer.accept(LinterStatus.COMPILING);
        Optional<CompilationResult> compilationResult = Compiler.compileToJar(file, tmpLocation, file.getVersion());
        if (compilationResult.isEmpty()) {
            return List.of();
        }
        ArrayList<PMDCheck> pmdChecks = new ArrayList<PMDCheck>();
        ArrayList<SpotbugsCheck> spotbugsChecks = new ArrayList<SpotbugsCheck>();
        ArrayList<CopyPasteCheck> cpdChecks = new ArrayList<CopyPasteCheck>();
        ArrayList<IntegratedCheck> integratedChecks = new ArrayList<IntegratedCheck>();
        for (Check check : checks) {
            if (check instanceof PMDCheck) {
                PMDCheck pmdCheck = (PMDCheck)check;
                pmdChecks.add(pmdCheck);
                continue;
            }
            if (check instanceof CopyPasteCheck) {
                CopyPasteCheck cpdCheck = (CopyPasteCheck)check;
                cpdChecks.add(cpdCheck);
                continue;
            }
            if (check instanceof SpotbugsCheck) {
                SpotbugsCheck spotbugsCheck = (SpotbugsCheck)check;
                spotbugsChecks.add(spotbugsCheck);
                continue;
            }
            if (check instanceof IntegratedCheck) {
                IntegratedCheck integratedCheck = (IntegratedCheck)check;
                integratedChecks.add(integratedCheck);
                continue;
            }
            throw new IllegalStateException();
        }
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (!pmdChecks.isEmpty()) {
            statusConsumer.accept(LinterStatus.RUNNING_PMD);
            problems.addAll(new PMDLinter().lint(file, pmdChecks));
        }
        if (!cpdChecks.isEmpty()) {
            statusConsumer.accept(LinterStatus.RUNNING_CPD);
            problems.addAll(new CPDLinter().lint(file, cpdChecks));
        }
        if (!spotbugsChecks.isEmpty()) {
            statusConsumer.accept(LinterStatus.RUNNING_SPOTBUGS);
            problems.addAll(new SpotbugsLinter().lint(compilationResult.get().jar(), spotbugsChecks));
        }
        if (!integratedChecks.isEmpty()) {
            try (IntegratedAnalysis analysis = new IntegratedAnalysis(file, compilationResult.get().jar(), tmpLocation, statusConsumer);){
                if (!disableDynamicAnalysis) {
                    analysis.runDynamicAnalysis(tests, statusConsumer);
                }
                problems.addAll(analysis.lint(integratedChecks, statusConsumer));
            }
        }
        compilationResult.get().jar().toFile().delete();
        if (problemsToReport.isEmpty()) {
            return problems;
        }
        return problems.stream().filter(p -> problemsToReport.contains((Object)p.getProblemType())).toList();
    }

    public String translateMessage(LocalizedMessage message) {
        String output = message.format(this.fluentBundle);
        if (output.startsWith("Unknown messageID '")) {
            return output.substring("Unknown messageID '".length(), output.length() - 1);
        }
        return output;
    }

    private List<Check> findChecksForProblemTypes(List<ProblemType> problems) {
        Reflections reflections = new Reflections("de.firemage.autograder.core.check", new Scanner[0]);
        return reflections.getTypesAnnotatedWith(ExecutableCheck.class).stream().filter(c -> this.isRequiredCheck(c.getAnnotation(ExecutableCheck.class), problems)).map(c -> {
            try {
                return (Check)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate check " + c.getName(), e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(c.getName() + " does not inherit from Check");
            }
        }).toList();
    }

    private boolean isRequiredCheck(ExecutableCheck check, List<ProblemType> problems) {
        return problems.stream().anyMatch(p -> List.of(check.reportedProblems()).contains(p));
    }
}

