/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.firemage.autograder.cmd.CmdUtil;
import de.firemage.autograder.cmd.ProgressAnimation;
import de.firemage.autograder.cmd.output.Annotation;
import de.firemage.autograder.core.ArtemisUtil;
import de.firemage.autograder.core.CheckConfiguration;
import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.Linter;
import de.firemage.autograder.core.LinterConfigurationException;
import de.firemage.autograder.core.LinterException;
import de.firemage.autograder.core.LinterStatus;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.compiler.CompilationFailureException;
import de.firemage.autograder.core.compiler.JavaVersion;
import de.firemage.autograder.core.errorprone.TempLocation;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.span.Formatter;
import de.firemage.autograder.span.Highlight;
import de.firemage.autograder.span.Position;
import de.firemage.autograder.span.Span;
import de.firemage.autograder.span.Style;
import de.firemage.autograder.span.Text;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true, version={"codelinter-cmd 1.0"}, description={"Static code analysis for student java code"})
public class Application
implements Callable<Integer> {
    private static final int IO_EXIT_CODE = 3;
    private static final int COMPILATION_EXIT_CODE = 4;
    private static final int MISC_EXIT_CODE = 10;
    private static final int CAPTION_LENGTH = 20;
    @CommandLine.Parameters(index="0", description={"The check configuration."})
    private String checkConfig;
    @CommandLine.Parameters(index="1", description={"The root folder which contains the files to check."})
    private Path file;
    @CommandLine.Option(names={"-j", "--java", "--java-version"}, defaultValue="17", description={"Set the Java version."})
    private String javaVersion;
    @CommandLine.Option(names={"--artemis"}, description={"Assume that the given root folder is the workspace root of the grading tool."})
    private boolean artemisFolders;
    @CommandLine.Option(names={"--output-json"}, description={"Output the found problems in JSON format instead of more readable plain text"})
    private boolean outputJson;
    @CommandLine.Option(names={"--static-only"}, description={"Only kept here so the grading tool keeps working, does nothing."})
    private boolean staticOnly;
    @CommandLine.Option(names={"--pass-config"}, description={"Interpret the first parameter not as the path to a config file, but as the contents of the config file"})
    private boolean passConfig;
    @CommandLine.Option(names={"-p", "--output-pretty"}, description={"Pretty print the output"}, defaultValue="false")
    private boolean isPrettyOutput;
    @CommandLine.Option(names={"--max-problems"}, description={"The maximum number of problems to report per check"}, defaultValue="10")
    private int maxProblemsPerCheck;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private final TempLocation tempLocation;

    public Application(TempLocation tempLocation) {
        this.tempLocation = tempLocation;
    }

    private static Charset getConsoleCharset() {
        return System.console() == null ? StandardCharsets.UTF_8 : System.console().charset();
    }

    public static void main(String ... args) {
        System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, Application.getConsoleCharset()));
        int exitCode = Application.runApplication(args);
        System.exit(exitCode);
    }

    public static int runApplication(String ... args) {
        int n;
        block8: {
            TempLocation tempLocation = TempLocation.of((String)".autograder-tmp", (String[])new String[0]);
            try {
                n = new CommandLine((Object)new Application(tempLocation)).execute(args);
                if (tempLocation == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tempLocation != null) {
                        try {
                            tempLocation.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new IllegalArgumentException("Could not create temp location", exception);
                }
            }
            tempLocation.close();
        }
        return n;
    }

    private static Highlight highlightFromCodePosition(CodePosition codePosition, String label) {
        return new Highlight(new Span(new Position(codePosition.startLine() - 1, codePosition.startColumn() - 1), new Position(codePosition.endLine() - 1, codePosition.endColumn() - 1)), Optional.ofNullable(label), Style.ERROR);
    }

    private void execute(Linter linter, CheckConfiguration checkConfiguration, UploadedFile uploadedFile, Consumer<LinterStatus> statusConsumer) throws LinterException, IOException {
        if (this.outputJson) {
            List problems = linter.checkFile(uploadedFile, checkConfiguration, statusConsumer);
            System.out.println(">> Problems <<");
            this.printProblemsAsJson(problems, linter);
            return;
        }
        if (this.isPrettyOutput) {
            CmdUtil.beginSection("Checks");
            ProgressAnimation progress = new ProgressAnimation("Checking...");
            progress.start();
            List problems = linter.checkFile(uploadedFile, checkConfiguration, statusConsumer);
            progress.finish("Completed checks");
            if (problems.isEmpty()) {
                CmdUtil.println("No problems found - good job!");
            } else {
                CmdUtil.println("Found " + problems.size() + " problem(s):");
                problems.stream().map(problem -> {
                    CodePosition position = problem.getPosition();
                    Text sourceText = Text.fromString((int)0, (String)position.readString());
                    Formatter formatter = new Formatter(System.lineSeparator(), Application.highlightFromCodePosition(position, linter.translateMessage(problem.getExplanation())));
                    Object result = "[%s]: %s - Found problem in '%s'%n".formatted(problem.getProblemType(), problem.getCheck().getClass().getSimpleName(), position.toString());
                    result = (String)result + formatter.render(sourceText);
                    return result;
                }).forEach(string -> CmdUtil.println(string + System.lineSeparator()));
            }
            CmdUtil.endSection();
            return;
        }
        CmdUtil.beginSection("Checks");
        ProgressAnimation progress = new ProgressAnimation("Checking...");
        progress.start();
        List problems = linter.checkFile(uploadedFile, checkConfiguration, statusConsumer);
        progress.finish("Completed checks");
        this.printProblems(problems, linter);
        CmdUtil.endSection();
    }

    @Override
    public Integer call() {
        CheckConfiguration checkConfiguration;
        if (!JavaVersion.isValidJavaVersion((String)this.javaVersion)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Unknown java version '" + this.javaVersion + "'");
        }
        if (this.artemisFolders) {
            try {
                this.file = ArtemisUtil.resolveCodePathEclipseGradingTool((Path)this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
                return 3;
            }
        }
        if (!this.outputJson) {
            System.out.println("Student source code directory is " + String.valueOf(this.file));
        }
        try {
            checkConfiguration = this.passConfig ? CheckConfiguration.fromConfigString((String)this.checkConfig) : CheckConfiguration.fromConfigFile((Path)Path.of(this.checkConfig, new String[0]));
        }
        catch (LinterConfigurationException | IOException e) {
            e.printStackTrace();
            return 3;
        }
        Linter linter = Linter.builder((Locale)Locale.GERMANY).threads(0).tempLocation(this.tempLocation).maxProblemsPerCheck(this.maxProblemsPerCheck).build();
        Consumer<LinterStatus> statusConsumer = status -> System.out.println(linter.translateMessage((Translatable)status.getMessage()));
        if (!Files.exists(this.file, new LinkOption[0])) {
            CmdUtil.printlnErr("The path '%s' does not exist".formatted(this.file));
            return 4;
        }
        try (UploadedFile uploadedFile = UploadedFile.build((Path)this.file, (JavaVersion)JavaVersion.fromString((String)this.javaVersion), (TempLocation)this.tempLocation, statusConsumer, null);){
            this.execute(linter, checkConfiguration, uploadedFile, statusConsumer);
        }
        catch (CompilationFailureException e) {
            CmdUtil.printlnErr("Compilation failed: " + e.getMessage());
            return 4;
        }
        catch (LinterException e) {
            e.printStackTrace();
            return 10;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 3;
        }
        return 0;
    }

    private void printProblems(List<Problem> problems, Linter linter) {
        if (problems.isEmpty()) {
            CmdUtil.println("No problems found - good job!");
        } else {
            CmdUtil.println("Found " + problems.size() + " problem(s):");
            problems.stream().map(p -> this.formatProblem((Problem)p, linter)).sorted().forEach(CmdUtil::println);
        }
    }

    private void printProblemsAsJson(Collection<? extends Problem> problems, Linter linter) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String jsonOutput = mapper.writeValueAsString(problems.stream().map(problem -> {
                CodePosition position = problem.getPosition();
                return new Annotation(problem.getProblemType(), linter.translateMessage(problem.getExplanation()), position.file().toString().replace("\\", "/"), position.startLine(), position.endLine());
            }).toList());
            System.out.println(jsonOutput);
        }
        catch (JsonProcessingException ex) {
            ex.printStackTrace();
        }
    }

    private String formatProblem(Problem problem, Linter linter) {
        return String.format("%s %s (Source: %s)", problem.getDisplayLocation(), linter.translateMessage(problem.getExplanation()), linter.translateMessage((Translatable)problem.getCheck().getLinter()));
    }
}

