/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.cmd;

import de.firemage.autograder.cmd.CmdUtil;

public class ProgressAnimation {
    private final Thread outputThread;
    private String text;
    private String lastLine = "";

    public ProgressAnimation(String initialText) {
        this.text = initialText;
        this.outputThread = new Thread(() -> {
            int step = 0;
            while (!Thread.currentThread().isInterrupted()) {
                Object output = "";
                output = (String)output + (switch (step) {
                    case 0 -> "[ - ]";
                    case 1 -> "[ \\ ]";
                    case 2 -> "[ | ]";
                    case 3 -> "[ / ]";
                    default -> throw new IllegalStateException();
                });
                output = (String)output + " " + this.text;
                step = (step + 1) % 4;
                this.print((String)output);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        this.outputThread.setDaemon(true);
    }

    public ProgressAnimation() {
        this("");
    }

    public void start() {
        this.outputThread.start();
    }

    public void updateText(String text) {
        this.text = text;
    }

    public void finish(String finalText) {
        this.outputThread.interrupt();
        this.print(finalText);
        CmdUtil.println();
    }

    private void print(String line) {
        if (this.lastLine.length() > line.length()) {
            Object temp = "";
            if (((String)(temp = (String)temp + " ".repeat(this.lastLine.length()))).length() > 1) {
                CmdUtil.print("\r" + (String)temp);
            }
        }
        CmdUtil.print("\r" + line);
        this.lastLine = line;
    }
}

