/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.agent;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;

public class MethodInstrumentationVisitor
extends AdviceAdapter {
    private static final Type RECORDER = Type.getType("Lde/firemage/autograder/agent/EventRecorder;");
    private final String className;
    private final Label startFinally;
    private boolean initialized = false;

    public MethodInstrumentationVisitor(MethodVisitor visitor, int access, String name, String descriptor, String className) {
        super(589824, visitor, access, name, descriptor);
        this.className = className;
        this.startFinally = new Label();
    }

    @Override
    protected void onMethodEnter() {
        this.initialized = true;
        this.visitLabel(this.startFinally);
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.getName());
        this.visitLdcInsn(this.methodDesc);
        this.invokeStatic(RECORDER, new Method("recordMethodEnter", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (!this.initialized) {
            return;
        }
        if (opcode == 176) {
            this.dup();
            int returnValue = this.newLocal(this.getReturnType());
            this.storeLocal(returnValue);
            this.visitLdcInsn(this.className);
            this.visitLdcInsn(this.getName());
            this.visitLdcInsn(this.methodDesc);
            this.loadLocal(returnValue);
            this.invokeStatic(RECORDER, new Method("recordReferenceReturn", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V"));
        } else if (opcode != 191 && opcode != 177) {
            if (opcode == 175 || opcode == 173) {
                this.dup2();
            } else {
                this.dup();
            }
            int returnValue = this.newLocal(this.getReturnType());
            this.storeLocal(returnValue);
            this.visitLdcInsn(this.className);
            this.visitLdcInsn(this.getName());
            this.visitLdcInsn(this.methodDesc);
            this.loadLocal(returnValue);
            this.box(this.getReturnType());
            this.invokeStatic(RECORDER, new Method("recordPrimitiveReturn", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V"));
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        if (!this.initialized) {
            return;
        }
        if (opcode == 181) {
            int value = this.newLocal(Type.getType(descriptor));
            this.storeLocal(value);
            int target = this.newLocal(Type.getObjectType(owner));
            this.storeLocal(target);
            this.visitLdcInsn(this.className);
            this.visitLdcInsn(this.getName());
            this.visitLdcInsn(this.methodDesc);
            this.loadLocal(target);
            this.visitLdcInsn(name);
            this.loadLocal(value);
            this.invokeStatic(RECORDER, new Method("recordPutField", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;" + this.generifyDescriptor(descriptor) + ")V"));
            this.loadLocal(target);
            this.loadLocal(value);
        } else if (opcode == 180) {
            int target = this.newLocal(Type.getObjectType(owner));
            this.storeLocal(target);
            this.visitLdcInsn(this.className);
            this.visitLdcInsn(this.getName());
            this.visitLdcInsn(this.methodDesc);
            this.loadLocal(target);
            this.visitLdcInsn(name);
            this.loadLocal(target);
            this.getField(Type.getObjectType(owner), name, Type.getType(descriptor));
            this.invokeStatic(RECORDER, new Method("recordGetField", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;" + this.generifyDescriptor(descriptor) + ")V"));
            this.loadLocal(target);
        }
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (!this.initialized) {
            return;
        }
        Label endFinally = new Label();
        this.visitTryCatchBlock(this.startFinally, endFinally, endFinally, "java/lang/Throwable");
        this.visitLabel(endFinally);
        this.dup();
        int exception = this.newLocal(Type.getObjectType("Ljava/lang/Throwable;"));
        this.storeLocal(exception);
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.getName());
        this.visitLdcInsn(this.methodDesc);
        this.loadLocal(exception);
        this.invokeStatic(RECORDER, new Method("recordExitThrow", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V"));
        this.throwException();
        super.visitMaxs(maxStack, maxLocals);
    }

    private String generifyDescriptor(String descriptor) {
        if (descriptor.startsWith("L") || descriptor.startsWith("[")) {
            return "Ljava/lang/Object;";
        }
        return descriptor;
    }
}

