/*
 * Decompiled with CFR 0.152.
 */
package de.firehead.mapstruct.spi.protobuf.enums;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.spi.DefaultEnumMappingStrategy;

public class ProtobufEnumMappingStrategy
extends DefaultEnumMappingStrategy {
    private static final String DEFAULT_ENUM_POSTFIX = "UNSPECIFIED";
    private static final String UNPARSEABLE_ENUM_CONSTANT = "UNRECOGNIZED";
    private static final String PROTOBUF_ENUM_INTERFACE_NAME = "com.google.protobuf.ProtocolMessageEnum";
    private static final String PROTOBUF_LITE_ENUM_INTERFACE_NAME = "com.google.protobuf.Internal.EnumLite";

    public String getDefaultNullEnumConstant(TypeElement anEnumType) {
        if (this.isProtobufEnum(anEnumType)) {
            String prefix = ProtobufEnumMappingStrategy.upperCamelToUpperUnderscore(anEnumType.getSimpleName().toString());
            return prefix + "_" + DEFAULT_ENUM_POSTFIX;
        }
        return null;
    }

    public String getEnumConstant(TypeElement anEnumType, String aSourceEnumValue) {
        if (this.isProtobufEnum(anEnumType)) {
            if (aSourceEnumValue == null) {
                return this.getDefaultNullEnumConstant(anEnumType);
            }
            String enumWithoutNamePrefix = this.removeEnumNamePrefixFromValueIfPossible(anEnumType, aSourceEnumValue);
            if (UNPARSEABLE_ENUM_CONSTANT.equals(aSourceEnumValue) || DEFAULT_ENUM_POSTFIX.equals(enumWithoutNamePrefix)) {
                return "<NULL>";
            }
            return enumWithoutNamePrefix;
        }
        return aSourceEnumValue;
    }

    private String removeEnumNamePrefixFromValueIfPossible(TypeElement anEnumType, String anEnumValue) {
        String prefix = ProtobufEnumMappingStrategy.upperCamelToUpperUnderscore(anEnumType.getSimpleName().toString());
        return anEnumValue.replace(prefix + "_", "");
    }

    private boolean isProtobufEnum(TypeElement anEnumType) {
        for (TypeMirror typeMirror : anEnumType.getInterfaces()) {
            String implementedInterfaceName = typeMirror.toString();
            if (!PROTOBUF_ENUM_INTERFACE_NAME.equals(implementedInterfaceName) && !PROTOBUF_LITE_ENUM_INTERFACE_NAME.equals(implementedInterfaceName)) continue;
            return true;
        }
        return false;
    }

    private static String upperCamelToUpperUnderscore(String anInput) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        String result = anInput.replaceAll("([a-z])([A-Z]+)", "$1_$2");
        return result.toUpperCase();
    }
}

