/*
 * Decompiled with CFR 0.152.
 */
package de.firehead.mapstruct.spi.protobuf.builderprovider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import org.mapstruct.ap.spi.BuilderInfo;
import org.mapstruct.ap.spi.DefaultBuilderProvider;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class ImmutablesBuilderProvider
extends DefaultBuilderProvider {
    private static final Pattern JAVA_JAVAX_PACKAGE = Pattern.compile("^javax?\\..*");
    private static final String IMMUTABLE_FQN = "org.immutables.value.Value.Immutable";
    private static final String VALUE_ENCLOSING_FQN = "org.immutables.value.Value.Enclosing";
    private static final String VALUE_STYLE_FQN = "org.immutables.value.Value.Style";

    protected BuilderInfo findBuilderInfo(TypeElement typeElement) {
        BuilderInfo info;
        Name name = typeElement.getQualifiedName();
        if (name.length() == 0 || JAVA_JAVAX_PACKAGE.matcher(name).matches()) {
            return null;
        }
        TypeElement immutableAnnotation = this.elementUtils.getTypeElement(IMMUTABLE_FQN);
        if (immutableAnnotation != null && (info = this.findBuilderInfoForImmutables(typeElement, immutableAnnotation)) != null) {
            return info;
        }
        return super.findBuilderInfo(typeElement);
    }

    protected BuilderInfo findBuilderInfoForImmutables(TypeElement targetTypeElement, TypeElement immutableAnnotation) {
        BuilderInfo fromType = super.findBuilderInfo(targetTypeElement);
        if (fromType != null) {
            return fromType;
        }
        return this.findTypeWithImmutableAnnotation(targetTypeElement, immutableAnnotation.asType()).map(typeElement -> {
            TypeElement immutableElement = this.asImmutableElement((TypeElement)typeElement);
            if (immutableElement != null) {
                return super.findBuilderInfo(immutableElement);
            }
            throw new TypeHierarchyErroneousException(typeElement);
        }).orElse(null);
    }

    protected Optional<TypeElement> findTypeWithImmutableAnnotation(TypeElement targetTypeElement, TypeMirror immutableAnnotationTypeMirror) {
        Predicate<Element> hasImmutableAnnotation = element -> this.elementUtils.getAllAnnotationMirrors((Element)element).stream().anyMatch(am -> this.typeUtils.isSameType(am.getAnnotationType(), immutableAnnotationTypeMirror));
        if (hasImmutableAnnotation.test(targetTypeElement)) {
            return Optional.of(targetTypeElement);
        }
        String targetPackage = this.findPackage(targetTypeElement);
        return Stream.concat(targetTypeElement.getInterfaces().stream(), Stream.of(targetTypeElement.getSuperclass())).filter(intf -> intf.getKind() == TypeKind.DECLARED).map(DeclaredType.class::cast).map(DeclaredType::asElement).map(TypeElement.class::cast).filter(intf -> targetPackage.equals(this.findPackage((Element)intf))).filter(hasImmutableAnnotation).findFirst();
    }

    protected TypeElement asImmutableElement(TypeElement typeElement) {
        String enclosingQualifier = "";
        AnnotationMirror style = null;
        Element enclosingElement = typeElement.getEnclosingElement();
        while (enclosingElement.getKind() != ElementKind.PACKAGE) {
            if (this.hasValueEnclosingAnnotation(enclosingElement) && enclosingQualifier.isEmpty()) {
                style = this.findStyle(enclosingElement);
                enclosingQualifier = style != null ? this.enclosingQualifierFromStyle(style, enclosingElement) : "Immutable" + enclosingElement.getSimpleName();
            }
            enclosingElement = enclosingElement.getEnclosingElement();
        }
        String packageQualifier = ((PackageElement)enclosingElement).getQualifiedName().toString();
        String builderName = this.builderFromStyle(style, typeElement, !enclosingQualifier.isEmpty());
        String bqn = Stream.of(packageQualifier, enclosingQualifier, builderName).filter(segment -> !segment.isEmpty()).collect(Collectors.joining("."));
        return this.elementUtils.getTypeElement(bqn);
    }

    protected String enclosingQualifierFromStyle(AnnotationMirror style, Element element) {
        return this.immutableNameFromStylePattern(this.nameWithoutAbstractPrefix(style, element), this.getSingleAnnotationValue("typeImmutable", style).orElseGet(() -> this.getSingleAnnotationValue("typeImmutableEnclosing", style).orElse("Immutable*")));
    }

    protected String builderFromStyle(AnnotationMirror style, TypeElement element, boolean valueEnclosingFound) {
        assert (element != null);
        AnnotationMirror resolvedStyle = Optional.ofNullable(style).orElseGet(() -> {
            AnnotationMirror found = null;
            for (Element currentElement = element; currentElement != null && found == null; currentElement = currentElement.getEnclosingElement()) {
                found = this.findStyle(currentElement);
            }
            return found;
        });
        if (resolvedStyle == null && !valueEnclosingFound) {
            return "Immutable" + element.getSimpleName();
        }
        if (resolvedStyle == null) {
            return element.getSimpleName().toString();
        }
        return this.immutableNameFromStylePattern(this.nameWithoutAbstractPrefix(resolvedStyle, element), this.getSingleAnnotationValue("typeImmutable", resolvedStyle).orElse("Immutable*"));
    }

    protected String nameWithoutAbstractPrefix(AnnotationMirror style, Element element) {
        String simpleNameOfElement = element.getSimpleName().toString();
        return this.getTypeAbstractValues(style).stream().filter(p -> simpleNameOfElement.startsWith(p.substring(0, p.length() - 1))).map(p -> simpleNameOfElement.substring(p.length() - 1)).findFirst().orElseGet(() -> element.getSimpleName().toString());
    }

    protected Optional<String> getSingleAnnotationValue(String annotationKey, AnnotationMirror style) {
        return this.elementUtils.getElementValuesWithDefaults(style).entrySet().stream().filter(entry -> annotationKey.equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).map(Map.Entry::getValue).map(value -> value.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

            @Override
            public String visitString(String s, Void unused) {
                return s;
            }
        }, null)).findFirst();
    }

    protected List<String> getTypeAbstractValues(AnnotationMirror styleOrNull) {
        Supplier<List> noStyleOrMissingDefault = () -> Collections.singletonList("Abstract*");
        return Optional.ofNullable(styleOrNull).map(style -> this.elementUtils.getElementValuesWithDefaults((AnnotationMirror)style).entrySet().stream().filter(entry -> "typeAbstract".equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).map(Map.Entry::getValue).map(value -> value.accept(new SimpleAnnotationValueVisitor8<List<String>, Void>(){

            @Override
            public List<String> visitArray(List<? extends AnnotationValue> values, Void unused) {
                return values.stream().map(val -> val.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

                    @Override
                    public String visitString(String s, Void param) {
                        return s;
                    }
                }, null)).collect(Collectors.toList());
            }
        }, null)).findFirst().orElseGet(noStyleOrMissingDefault)).orElseGet(noStyleOrMissingDefault);
    }

    protected boolean hasValueEnclosingAnnotation(Element enclosingElement) {
        TypeElement typeElement = this.elementUtils.getTypeElement(VALUE_ENCLOSING_FQN);
        return Optional.ofNullable(typeElement).map(Element::asType).map(mirror -> this.elementUtils.getAllAnnotationMirrors(enclosingElement).stream().anyMatch(am -> this.typeUtils.isSameType(am.getAnnotationType(), (TypeMirror)mirror))).orElse(Boolean.FALSE);
    }

    protected AnnotationMirror findStyle(Element element) {
        TypeElement styleTypeElement = this.elementUtils.getTypeElement(VALUE_STYLE_FQN);
        if (styleTypeElement == null) {
            return null;
        }
        TypeMirror styleAnnotation = styleTypeElement.asType();
        return this.elementUtils.getAllAnnotationMirrors(element).stream().filter(am -> this.typeUtils.isSameType(am.getAnnotationType(), styleAnnotation)).findFirst().orElse(null);
    }

    protected String immutableNameFromStylePattern(String simpleNameOfElement, String typeImmutablePattern) {
        String fixedPattern = typeImmutablePattern.substring(0, typeImmutablePattern.length() - 1);
        return fixedPattern + simpleNameOfElement;
    }

    protected String findPackage(Element element) {
        Element current = element;
        while (current.getKind() != ElementKind.PACKAGE) {
            current = current.getEnclosingElement();
        }
        return current.getSimpleName().toString();
    }
}

