/*
 * Decompiled with CFR 0.152.
 */
package de.firehead.mapstruct.spi.protobuf.accessors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.util.Nouns;
import org.mapstruct.ap.spi.DefaultAccessorNamingStrategy;
import org.mapstruct.ap.spi.MapStructProcessingEnvironment;
import org.mapstruct.ap.spi.util.IntrospectorUtils;

public class ProtobufAccessorNamingStrategy
extends DefaultAccessorNamingStrategy {
    protected TypeMirror protobufMarkerInterface;
    protected boolean isImmutables;
    private static final Set<String> INTERNAL_PROTOBUF_METHODS = new HashSet<String>(Arrays.asList("clear", "clearField", "clearOneof", "getAllFields", "getAllFieldsMutable", "getAllFieldsRaw", "getDefaultInstance", "getDefaultInstanceForType", "getDescriptor", "getDescriptorForType", "getField", "getFieldRaw", "getInitializationErrorString", "getMemoizedSerializedSize", "getOneofFieldDescriptor", "getParserForType", "getRepeatedField", "getRepeatedFieldCount", "getSerializedSize", "getSerializingExceptionMessage", "getUnknownFields", "isInitialized", "mergeFrom", "mergeUnknownFields", "newBuilder", "newBuilderForType", "parseDelimitedFrom", "parseFrom", "setRepeatedField", "setUnknownFields"));

    public void init(MapStructProcessingEnvironment aProcessingEnvironment) {
        super.init(aProcessingEnvironment);
        TypeElement typeElement = this.elementUtils.getTypeElement("com.google.protobuf.MessageLiteOrBuilder");
        if (typeElement != null) {
            this.protobufMarkerInterface = typeElement.asType();
        }
        this.isImmutables = this.elementUtils.getTypeElement("org.immutables.value.Value.Immutable") != null;
    }

    private boolean isProtobufGeneratedMessage(TypeElement aType) {
        for (TypeMirror typeMirror : aType.getInterfaces()) {
            if (typeMirror.toString().startsWith("com.google.protobuf.MessageLiteOrBuilder")) {
                return true;
            }
            if (!(typeMirror instanceof DeclaredType) || !this.isProtobufGeneratedMessage((TypeElement)((DeclaredType)typeMirror).asElement())) continue;
            return true;
        }
        TypeMirror superType = aType.getSuperclass();
        if (superType instanceof DeclaredType) {
            return this.isProtobufGeneratedMessage((TypeElement)((DeclaredType)superType).asElement());
        }
        return false;
    }

    private boolean isInternalProtobufMethod(ExecutableElement aMethod) {
        return INTERNAL_PROTOBUF_METHODS.contains(aMethod.getSimpleName().toString());
    }

    private boolean isProtobufMethod(ExecutableElement aMethod) {
        return aMethod.getKind() == ElementKind.METHOD && aMethod.getEnclosingElement() != null && this.protobufMarkerInterface != null && this.typeUtils.isAssignable(aMethod.getEnclosingElement().asType(), this.protobufMarkerInterface);
    }

    private boolean doesHaveMethod(TypeElement aType, String aMethodName) {
        return aType.getEnclosedElements().stream().anyMatch(e -> e.getSimpleName().toString().equals(aMethodName));
    }

    private boolean isAuxiliaryProtobufPropertyAccessor(ExecutableElement aMethod) {
        String expectedAccessor;
        if (!this.isProtobufMethod(aMethod)) {
            return false;
        }
        String methodName = aMethod.getSimpleName().toString();
        if (methodName.startsWith("getOneOf") && methodName.endsWith("Case")) {
            return true;
        }
        for (String prefixCandidate : Arrays.asList("clear", "merge", "mutable", "putAll", "remove")) {
            if (!methodName.startsWith(prefixCandidate)) continue;
            expectedAccessor = "get" + methodName.substring(prefixCandidate.length());
            if (!this.doesHaveMethod((TypeElement)aMethod.getEnclosingElement(), expectedAccessor)) continue;
            return true;
        }
        for (String suffixCandidate : Arrays.asList("Bytes", "Count", "Map", "Value", "ValueList")) {
            if (!methodName.endsWith(suffixCandidate)) continue;
            expectedAccessor = methodName.substring(0, methodName.length() - suffixCandidate.length());
            if (!this.doesHaveMethod((TypeElement)aMethod.getEnclosingElement(), expectedAccessor)) continue;
            return true;
        }
        return false;
    }

    private boolean isListType(TypeMirror aType) {
        String typeString = aType.toString();
        return typeString.startsWith(List.class.getCanonicalName()) || typeString.startsWith("com.google.protobuf.ProtocolStringList");
    }

    private boolean isMapType(TypeMirror aType) {
        return aType.toString().startsWith(Map.class.getCanonicalName());
    }

    private boolean isMapEntryType(TypeMirror aType) {
        return aType.toString().startsWith(Map.Entry.class.getCanonicalName());
    }

    private boolean isMutableMapAccessor(ExecutableElement aMethod) {
        return aMethod.getSimpleName().toString().startsWith("getMutable") && this.isMapType(aMethod.getReturnType());
    }

    private boolean isImmutableMapAccessor(ExecutableElement aMethod) {
        String methodName = aMethod.getSimpleName().toString();
        return methodName.startsWith("get") && !methodName.startsWith("getMutable") && this.isMapType(aMethod.getReturnType()) && (!methodName.endsWith("Map") || this.doesHaveMethod((TypeElement)aMethod.getEnclosingElement(), methodName + "Map"));
    }

    private boolean isListGetter(ExecutableElement aMethod) {
        return aMethod.getSimpleName().toString().startsWith("get") && this.isListType(aMethod.getReturnType());
    }

    private boolean isListSetter(ExecutableElement aMethod) {
        return aMethod.getSimpleName().toString().startsWith("set") && aMethod.getParameters().size() == 1 && this.isListType(aMethod.getParameters().get(0).asType());
    }

    private boolean isMapValuePutter(ExecutableElement aMethod) {
        return aMethod.getSimpleName().toString().startsWith("put") && aMethod.getParameters().size() == 2;
    }

    private boolean isMapEntryPutter(ExecutableElement aMethod) {
        return aMethod.getSimpleName().toString().startsWith("put") && aMethod.getParameters().size() == 1 && this.isMapEntryType(aMethod.getParameters().get(0).asType());
    }

    private boolean isMapEntryPutAll(ExecutableElement aMethod) {
        return aMethod.getSimpleName().toString().startsWith("putAll") && aMethod.getParameters().size() == 1 && this.isMapType(aMethod.getParameters().get(0).asType());
    }

    public boolean isGetterMethod(ExecutableElement aMethod) {
        if (this.isInternalProtobufMethod(aMethod) || this.isAuxiliaryProtobufPropertyAccessor(aMethod)) {
            return false;
        }
        String methodName = aMethod.getSimpleName().toString();
        if (methodName.endsWith("OrBuilder") || methodName.endsWith("BuilderList")) {
            return false;
        }
        if (this.isMutableMapAccessor(aMethod)) {
            return true;
        }
        if (this.isImmutableMapAccessor(aMethod)) {
            TypeElement type = (TypeElement)aMethod.getEnclosingElement();
            return !type.getSuperclass().toString().startsWith("com.google.protobuf.GeneratedMessageV3.Builder");
        }
        return super.isGetterMethod(aMethod);
    }

    public boolean isSetterMethod(ExecutableElement aMethod) {
        if (this.isInternalProtobufMethod(aMethod) || this.isAuxiliaryProtobufPropertyAccessor(aMethod)) {
            return false;
        }
        if (this.isMapEntryPutAll(aMethod) || this.isMapEntryPutter(aMethod) || this.isMapValuePutter(aMethod)) {
            return false;
        }
        return super.isSetterMethod(aMethod);
    }

    protected boolean isFluentSetter(ExecutableElement aMethod) {
        if (this.isImmutables && aMethod.getSimpleName().toString().equals("from")) {
            return false;
        }
        if (this.isInternalProtobufMethod(aMethod) || this.isAuxiliaryProtobufPropertyAccessor(aMethod)) {
            return false;
        }
        String methodName = aMethod.getSimpleName().toString();
        if (methodName.startsWith("get")) {
            return false;
        }
        return super.isFluentSetter(aMethod);
    }

    public boolean isAdderMethod(ExecutableElement aMethod) {
        if (this.isInternalProtobufMethod(aMethod) || this.isAuxiliaryProtobufPropertyAccessor(aMethod)) {
            return false;
        }
        return super.isAdderMethod(aMethod);
    }

    public boolean isPresenceCheckMethod(ExecutableElement aMethod) {
        if (this.isInternalProtobufMethod(aMethod) || this.isAuxiliaryProtobufPropertyAccessor(aMethod)) {
            return false;
        }
        return super.isPresenceCheckMethod(aMethod);
    }

    public String getElementName(ExecutableElement aMethod) {
        String methodName = super.getElementName(aMethod);
        if (this.isProtobufMethod(aMethod)) {
            return Nouns.singularize((String)methodName);
        }
        return methodName;
    }

    public String getPropertyName(ExecutableElement aMethod) {
        TypeElement type;
        Element receiver = aMethod.getEnclosingElement();
        if (receiver != null && (receiver.getKind() == ElementKind.CLASS || receiver.getKind() == ElementKind.INTERFACE) && this.isProtobufGeneratedMessage(type = (TypeElement)receiver)) {
            String methodName = aMethod.getSimpleName().toString();
            if (this.isListGetter(aMethod) || this.isListSetter(aMethod)) {
                return IntrospectorUtils.decapitalize((String)methodName.substring("get".length(), methodName.length() - "List".length()));
            }
            if (this.isMutableMapAccessor(aMethod)) {
                return IntrospectorUtils.decapitalize((String)methodName.substring("getMutable".length()));
            }
            if (this.isImmutableMapAccessor(aMethod)) {
                return IntrospectorUtils.decapitalize((String)methodName.substring("get".length()));
            }
        }
        return super.getPropertyName(aMethod);
    }
}

