/*
 * Decompiled with CFR 0.152.
 */
package de.firehead.compressor.maven.plugin.compressor;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdOutputStream;
import de.firehead.compressor.maven.plugin.compressor.AbstractAdaptableFileCompressor;
import java.io.File;
import java.io.IOException;

public class ZstdJniFileCompressor
extends AbstractAdaptableFileCompressor {
    @Override
    protected void compressFileBlock(File aSourceFile, File aTargetFile, Integer aCompressionLevel) throws IOException {
        byte[] inputBuffer = this.readFileContents(aSourceFile);
        byte[] outputBuffer = new byte[inputBuffer.length + this.getBlockCompressOutputBufferOversize(inputBuffer.length)];
        int compressedBytes = (int)Zstd.compress((byte[])outputBuffer, (byte[])inputBuffer, (int)this.filterCompressionLevel(aCompressionLevel));
        this.writeFileContents(aTargetFile, outputBuffer, 0, compressedBytes);
    }

    @Override
    protected void compressFileStreaming(File aSourceFile, File aTargetFile, Integer aCompressionLevel) throws IOException {
        this.compressStreaming(aSourceFile, aTargetFile, out -> {
            try {
                return new ZstdOutputStream(out, this.filterCompressionLevel(aCompressionLevel));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected int filterCompressionLevel(Integer aCompressionLevel) {
        return aCompressionLevel != null ? aCompressionLevel : 3;
    }
}

