/*
 * Decompiled with CFR 0.152.
 */
package de.firehead.compressor.maven.plugin.compressor;

import de.firehead.compressor.maven.plugin.compressor.FileCompressor;
import io.airlift.compress.Compressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;

public abstract class AbstractFileCompressor
implements FileCompressor {
    protected static final String TEMP_FILE_SUFFIX = ".temp";
    protected static final int STREAM_COMPRESS_READ_BUFFER_SIZE = 65535;
    protected static final int DEFAULT_BLOCK_COMPRESS_OUTPUT_BUFFER_OVERSIZE = 65535;

    protected int getBlockCompressOutputBufferOversize(int anInputBufferLength) {
        return 65535;
    }

    protected void ensureFileExistsAndIsReadable(File aFile) throws IOException {
        if (!aFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + aFile.getAbsolutePath());
        }
        if (!aFile.isFile()) {
            throw new IOException("File is not a file: " + aFile.getAbsolutePath());
        }
        if (!aFile.canRead()) {
            throw new IOException("File is not readable: " + aFile.getAbsolutePath());
        }
    }

    protected void ensureDirectoryContainingFileIsWritable(File aFile) throws IOException {
        File parentDir = aFile.getParentFile();
        if (!parentDir.isDirectory()) {
            throw new IOException("Parent directory is not a directory: " + parentDir.getAbsolutePath());
        }
        if (!parentDir.canWrite()) {
            throw new IOException("Cannot write into directory: " + parentDir.getAbsolutePath());
        }
    }

    protected void performAccessChecks(File aFile) throws IOException {
        this.ensureFileExistsAndIsReadable(aFile);
        this.ensureDirectoryContainingFileIsWritable(aFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readFileContents(File aFile) throws IOException {
        byte[] inputBuffer = new byte[(int)aFile.length()];
        try (FileInputStream in = new FileInputStream(aFile);){
            int bytesRead;
            for (int tempPosition = 0; tempPosition < inputBuffer.length; tempPosition += bytesRead) {
                bytesRead = in.read(inputBuffer, tempPosition, inputBuffer.length - tempPosition);
            }
        }
        return inputBuffer;
    }

    protected FileOutputStream openFileForWriting(File aFile) throws IOException {
        return new FileOutputStream(aFile);
    }

    protected void writeFileContents(File aFile, byte[] someContent) throws IOException {
        this.writeFileContents(aFile, someContent, 0, someContent.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFileContents(File aFile, byte[] someContent, int anOffset, int aLength) throws IOException {
        try (FileOutputStream out = this.openFileForWriting(aFile);){
            out.write(someContent, anOffset, aLength);
        }
    }

    protected void renameFileForced(File aSourceFile, File aTargetFile) throws IOException {
        this.ensureFileExistsAndIsReadable(aSourceFile);
        this.ensureDirectoryContainingFileIsWritable(aTargetFile);
        if (aTargetFile.exists()) {
            aTargetFile.delete();
        }
        aSourceFile.renameTo(aTargetFile);
    }

    @Override
    public File compressFile(File aFile, String aSuffix, Integer aCompressionLevel) throws IOException {
        this.performAccessChecks(aFile);
        if (aSuffix != null && !aSuffix.isEmpty()) {
            File targetFile = new File(aFile.getAbsolutePath() + aSuffix);
            this.compressFileInternally(aFile, targetFile, aCompressionLevel);
            return targetFile;
        }
        File targetFile = new File(aFile.getAbsolutePath() + TEMP_FILE_SUFFIX);
        this.compressFileInternally(aFile, targetFile, aCompressionLevel);
        this.renameFileForced(targetFile, aFile);
        return aFile;
    }

    protected abstract void compressFileInternally(File var1, File var2, Integer var3) throws IOException;

    protected void compressBlock(File aSourceFile, File aTargetFile, Compressor aCompressor) throws IOException {
        byte[] inputBuffer = this.readFileContents(aSourceFile);
        byte[] outputBuffer = new byte[inputBuffer.length + this.getBlockCompressOutputBufferOversize(inputBuffer.length)];
        int compressedBytes = aCompressor.compress(inputBuffer, 0, inputBuffer.length, outputBuffer, 0, outputBuffer.length);
        this.writeFileContents(aTargetFile, outputBuffer, 0, compressedBytes);
    }

    protected void compressStreaming(InputStream anInputStream, OutputStream anOutputStream) throws IOException {
        byte[] buffer = new byte[65535];
        int bytesRead;
        while ((bytesRead = anInputStream.read(buffer)) >= 0) {
            anOutputStream.write(buffer, 0, bytesRead);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compressStreaming(File aSourceFile, File aTargetFile, Function<OutputStream, OutputStream> aStreamSupplier) throws IOException {
        try (FileInputStream in = new FileInputStream(aSourceFile);
             FileOutputStream out = new FileOutputStream(aTargetFile);
             OutputStream hadoopOut = aStreamSupplier.apply(out);){
            this.compressStreaming(in, hadoopOut);
        }
    }
}

