/*
 * Decompiled with CFR 0.152.
 */
package de.firehead.compressor.maven.plugin.compressor;

import de.firehead.compressor.maven.plugin.compressor.AbstractFileCompressor;
import java.io.File;
import java.io.IOException;

public abstract class AbstractAdaptableFileCompressor
extends AbstractFileCompressor {
    private static final long DEFAULT_MAX_FILE_SIZE_FOR_BLOCK_PROCESSING = Long.parseLong(System.getProperty("de.firehead.compressor.maven.plugin.maxSizeForBlockProcessing", Integer.toString(0x40000000)));

    @Override
    public void compressFileInternally(File aSourceFile, File aTargetFile, Integer aCompressionLevel) throws IOException {
        if (aSourceFile.length() <= this.getMaxFileSizeForBlockProcessing()) {
            this.compressFileBlock(aSourceFile, aTargetFile, aCompressionLevel);
        } else {
            this.compressFileStreaming(aSourceFile, aTargetFile, aCompressionLevel);
        }
    }

    protected long getMaxFileSizeForBlockProcessing() {
        return DEFAULT_MAX_FILE_SIZE_FOR_BLOCK_PROCESSING;
    }

    protected abstract void compressFileBlock(File var1, File var2, Integer var3) throws IOException;

    protected abstract void compressFileStreaming(File var1, File var2, Integer var3) throws IOException;
}

