/*
 * Decompiled with CFR 0.152.
 */
package de.firehead.compressor.maven.plugin;

import de.firehead.compressor.maven.plugin.CompressionAlgorithm;
import de.firehead.compressor.maven.plugin.Compressionset;
import de.firehead.compressor.maven.plugin.Fileset;
import de.firehead.compressor.maven.plugin.compressor.FileCompressor;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="compress", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class CompressorMojo
extends AbstractMojo {
    @Parameter
    private Compressionset[] compressionsets;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Compressor is skipped.");
            return;
        }
        try {
            int numFiles = 0;
            for (Compressionset set : this.compressionsets) {
                numFiles += this.processCompressionSet(set);
            }
            this.getLog().info((CharSequence)("Compressed " + numFiles + " files in total"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing compression", (Exception)e);
        }
    }

    protected int processCompressionSet(Compressionset aSet) throws IOException {
        CompressionAlgorithm algorithm = aSet.getAlgorithm();
        FileCompressor compressor = algorithm.getFileCompressor();
        int numFilesTotal = 0;
        for (Fileset fileset : aSet.getFilesets()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(fileset.getDirectory());
            scanner.setExcludes(fileset.getExcludes());
            scanner.setIncludes(fileset.getIncludes());
            scanner.setFollowSymlinks(fileset.isFollowSymlinks());
            scanner.scan();
            long totalSourceSize = 0L;
            long totalTargetSize = 0L;
            for (String includedFile : scanner.getIncludedFiles()) {
                File sourceFile = new File(fileset.getDirectory(), includedFile);
                long sourceFileSize = sourceFile.length();
                File targetFile = compressor.compressFile(sourceFile, aSet.isAddSuffix() ? algorithm.getSuffix() : null, aSet.getCompressionLevel());
                long targetFileSize = targetFile.length();
                totalSourceSize += sourceFileSize;
                totalTargetSize += targetFileSize;
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Compressed '" + sourceFile + "' to '" + targetFile + "' using " + (Object)((Object)algorithm) + ": " + sourceFileSize + " bytes -> " + targetFileSize + " bytes (" + this.formatCompressionEfficiency(sourceFileSize, targetFileSize) + "%)"));
            }
            int numFiles = scanner.getIncludedFiles().length;
            this.getLog().info((CharSequence)("Compressed " + numFiles + " files using " + (Object)((Object)algorithm) + " at " + this.formatCompressionEfficiency(totalSourceSize, totalTargetSize) + "%"));
            numFilesTotal += numFiles;
        }
        return numFilesTotal;
    }

    protected String formatCompressionEfficiency(long aSourceSize, long aTargetSize) {
        return "" + (double)Math.round((double)aTargetSize / (double)aSourceSize * 10000.0) / 100.0;
    }
}

