/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.maven.plugin;

import lombok.Data;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * The configuration used to generate a nested class contained in a StructureDefinition  to
 * represent a component or an anonymous local type.
 */
@Data
public class NestedClass {

    /**
     * The full ID of the element for which the nested class is generated (e.g. Patient.name).
     */
    @Parameter(name = "elementId", required = true)
    private String elementId = null;

    /**
     * The class name
     */
    @Parameter(name = "enumName", required = true)
    private String className = null;

    /**
     * The name of the superclass the nested class is derived from
     */
    @Parameter(name = "superClass", required = true)
    private String superClass = null;

    /**
     * The instantiation mode
     */
    @Parameter(name = "instantiation")
    private String instantiation;
}
