/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.maven.plugin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * The configuration used to generate an {@link Class} for a
 * FHIR <a href="https://hl7.org/fhir/structuredefinition.html">StructureDefinition</a>.
 */
@Data
public class StructureDefinitionClass {

    /**
     * The URI of the StructureDefinition
     */
    @Parameter(name = "structureDefinition", required = true)
    private URI structureDefinition = null;

    /**
     * The target namespace
     */
    @Parameter(name = "targetNamespace")
    private String targetNamespace = null;

    /**
     * The class name
     */
    @Parameter(name = "enumName", required = true)
    private String className = null;

    /**
     * The instantiation mode
     */
    @Parameter(name = "instantiation")
    private String instantiation;

    /**
     * The list of nested classes to generate.
     */
    @Parameter(name = "nestedClasses", required = false)
    private final List<NestedClass> nestedClasses = new ArrayList<>();
}
