/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.maven.plugin;

import java.io.File;
import lombok.Data;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * The configuration of a package source (currently always a file, but might be extended to cover e.g. package
 * downloads in the future).
 */
@Data
public class PackageSource {

    /**
     * The source file
     */
    @Parameter(name = "sourceFile")
    private File sourceFile = null;
}
