/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.utilities;

import com.google.common.base.Strings;

/**
 * Various auxiliary methods for string manipulation.
 */
public final class StringUtilities {

    private StringUtilities() {
        // do not instantiate
    }

    /**
     * @param input the input string to translate
     * @return the input string with the first letter in upper case
     */
    public static String toFirstUpper(String input) {
        switch (input.length()) {
            case 0:
                return "";
            case 1:
                return input.toUpperCase();
            default:
                return input.substring(0, 1).toUpperCase() + input.substring(1);
        }
    }

    /**
     * @param input the input string to translate
     * @return the input string with the first letter in lower case
     */
    public static String toFirstLower(String input) {
        switch (input.length()) {
            case 0:
                return "";
            case 1:
                return input.toLowerCase();
            default:
                return input.substring(0, 1).toLowerCase() + input.substring(1);
        }
    }

    /**
     * Converts a string_with_separated_words into a stringWithSeparatedWords.
     *
     * @param input     the input string to translate
     * @param separator the separator to remove
     * @return the translated string
     */
    public static String separatorToCamelCase(String input, String separator) {
        if (Strings.isNullOrEmpty(separator)) {
            throw new IllegalArgumentException("Separator must be specified");
        }
        var temp = input;
        var separatorPos = temp.indexOf(separator);
        while (separatorPos >= 0) {
            final var left = (separatorPos == 0) ? "" : temp.substring(0, separatorPos);
            final var right = temp.substring(separatorPos + separator.length());
            temp = left + toFirstUpper(right);
            separatorPos = temp.indexOf(separator);
        }
        return temp;
    }
}
