/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.process.config;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Optional;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Singular;
import lombok.experimental.Accessors;

/**
 * This class describes the configuration used to generate an {@link Class} for
 * a FHIR <a href=
 * "https://hl7.org/fhir/structuredefinition.html">StructureDefinition</a>.
 */
@Getter
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class StructureDefinitionClassConfiguration {

    /**
     * The URI identifying the StructureDefinition.
     */
    private final URI structureDefinition;

    /**
     * The target namespace to use instead of the default namespace.
     */
    @Builder.Default
    private final Optional<String> targetNamespace = Optional.empty();

    /**
     * The name of the class to generate.
     */
    private final String className;

    /**
     * The instantiation mode to use.
     */
    private final StructureClassInstantiation instantiation;

    /**
     * Whether to use the Structure Definition's version (e.g. in the ResourceDef url)
     */
    @Accessors(fluent = true)
    private final boolean useVersion;

    /**
     * The nested classes that will be generated within the main class.
     */
    @Singular
    private final ImmutableList<NestedClassConfiguration> nestedClasses;
}
