/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.process;

import de.fhlintstone.process.config.ProcessConfiguration;

/**
 * Entry point of the code generation process. This interface is used by both the Maven plugin and the CLI to initiate the code generation.
 */
public interface IProcessor {

    /**
     * Execute the code generation process with the configuration supplied.
     * @param configuration
     * @throws ProcessException
     */
    void execute(ProcessConfiguration configuration) throws ProcessException;
}
