/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.packages;

import org.hl7.fhir.utilities.npm.NpmPackage;

/**
 * Representation of a FHIR package read from an input file.
 * This interface contains the methods that are only accessible within the core implementation package.
 * @see <a href="https://hl7.org/fhir/packages.html">FHIR Packages</a>
 */
interface IFhirPackageBase {

    /**
     * Returns the NPM package object
     * @return the NPM package object
     */
    NpmPackage getNpmPackage();
}
