/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.packages;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Singular;
import org.hl7.fhir.utilities.npm.NpmPackage;

/**
 * Default implementation of {@link IFhirPackage}.
 */
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class FhirPackage implements IFhirPackage {

    @Getter
    private final NpmPackage npmPackage;

    @Getter
    private final File sourceFile;

    @Getter
    private final String name;

    @Getter
    private final String version;

    @Getter
    @Builder.Default
    private final Optional<URL> canonicalURL = Optional.empty();

    @Getter
    @Singular
    private final ImmutableMap<String, String> dependencies;

    @Override
    public String toString() {
        return "FHIR Package " + this.name + " version " + this.version + " (source file " + this.sourceFile + ")";
    }
}
