/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.valueset;

import de.fhlintstone.fhir.dependencies.IDependencyGraph;
import de.fhlintstone.process.config.ProcessConfiguration;

/**
 * Interface of the generator that creates a Java enum to represent a FHIR
 * ValueSet.
 */
public interface IValueSetGenerator {

    /**
     * Generates the source code to represent the ValueSets configured from the dependency graph.
     *
     * @param globalConfiguration       the overall configuration
     * @param dependencyGraph           the dependency graph of the objects that might be affected by the generation
     * @return <code>true</code> if the generation succeeded, <code>false</code> in case of errors (which have already been logged at this point)
     */
    boolean generate(ProcessConfiguration globalConfiguration, IDependencyGraph dependencyGraph);
}
