/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.valueset;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.model.ICodeSystemAccessor;
import de.fhlintstone.accessors.model.IConceptDefinitionComponentAccessor;
import de.fhlintstone.accessors.model.IConceptSetFilterComponentAccessor;
import de.fhlintstone.generator.GeneratorException;

/**
 * Component to evaluate the filter expressions of a ValueSet.
 */
public interface IFilterCalculator {

    /**
     * Generates the list of {@link IConceptDefinitionComponentAccessor} matching
     * the provided filter used by the {@link ConstantGenerator}
     *
     * @param valueSetUrl        The value set URL the filter belong to.
     * @param filterAccessor     The filter to apply.
     * @param codeSystemAccessor The codeSystem containing the concepts to filter
     *                           on.
     * @return the list of matching concepts the filter.
     * @throws GeneratorException if the filter could not be applied to retrieve the matching concepts
     */
    ImmutableList<IConceptDefinitionComponentAccessor> getMatchingConcepts(
            String valueSetUrl,
            IConceptSetFilterComponentAccessor filterAccessor,
            ICodeSystemAccessor codeSystemAccessor)
            throws GeneratorException;
}
