/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.valueset;

import de.fhlintstone.generator.GeneratorException;

/**
 * Component of the {@link IValueSetGenerator} to produce the actual Java code.
 */
public interface ICodeEmitter {

    /**
     * Generates the Java code based on the input data provided.
     *
     * @param enumData the information about the enum to be generated
     * @throws GeneratorException when the generation failed
     */
    void generate(EnumData enumData) throws GeneratorException;
}
