/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.valueset;

import com.google.common.collect.ImmutableList;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.TypeName;
import java.util.Optional;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Singular;

/**
 * The information transferred from the {@link IValueSetGenerator} to the
 * {@link ICodeEmitter}.
 */
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class EnumData {

    /**
     * The name of the enum class to generate
     */
    @Getter
    private final ClassName className;

    /**
     * The name of the ValueSet.
     */
    @Getter
    private final String valueSetName;

    /**
     * The URL of the ValueSet.
     */
    @Getter
    private final String valueSetURL;

    /**
     * The description of the ValueSet.
     */
    @Getter
    private final Optional<String> description;

    /**
     * The name of the FHIR coding type the ValueSet is used for.
     */
    @Getter
    private final TypeName codingType;

    /**
     * The output path to write the enum to.
     */
    @Getter
    private final String outputPath;

    /**
     * The list of constants to include in the enum.
     */
    @Getter
    @Singular
    private final ImmutableList<EnumConstant> enumConstants;
}
